/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Category;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.ConsumerPriceIndex;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.model.Watchlist;
import name.abuchen.portfolio.money.CurrencyUnit;

public class Client {
    static final int MAJOR_VERSION = 1;
    public static final int CURRENT_VERSION = 50;
    public static final int VERSION_WITH_CURRENCY_SUPPORT = 29;
    private transient PropertyChangeSupport propertyChangeSupport;
    private int version = 50;
    private transient int fileVersionAfterRead = 50;
    private String baseCurrency = "EUR";
    private List<Security> securities = new ArrayList<Security>();
    private List<Watchlist> watchlists;
    @Deprecated
    private List<ConsumerPriceIndex> consumerPriceIndeces;
    private List<Account> accounts = new ArrayList<Account>();
    private List<Portfolio> portfolios = new ArrayList<Portfolio>();
    private List<InvestmentPlan> plans;
    private List<Taxonomy> taxonomies;
    private List<Dashboard> dashboards;
    private Map<String, String> properties;
    private ClientSettings settings;
    @Deprecated
    private String industryTaxonomyId;
    @Deprecated
    private Category rootCategory;
    private transient SecretKey secret;

    public Client() {
        this.doPostLoadInitialization();
    }

    final void doPostLoadInitialization() {
        if (this.watchlists == null) {
            this.watchlists = new ArrayList<Watchlist>();
        }
        if (this.consumerPriceIndeces == null) {
            this.consumerPriceIndeces = new ArrayList<ConsumerPriceIndex>();
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        if (this.plans == null) {
            this.plans = new ArrayList<InvestmentPlan>();
        }
        if (this.taxonomies == null) {
            this.taxonomies = new ArrayList<Taxonomy>();
        }
        if (this.dashboards == null) {
            this.dashboards = new ArrayList<Dashboard>();
        }
        if (this.settings == null) {
            this.settings = new ClientSettings();
        } else {
            this.settings.doPostLoadInitialization();
        }
    }

    int getVersion() {
        return this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public int getFileVersionAfterRead() {
        return this.fileVersionAfterRead;
    }

    void setFileVersionAfterRead(int fileVersionAfterRead) {
        this.fileVersionAfterRead = fileVersionAfterRead;
    }

    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
        this.propertyChangeSupport.firePropertyChange("baseCurrency", this.baseCurrency, this.baseCurrency);
    }

    public List<InvestmentPlan> getPlans() {
        return Collections.unmodifiableList(this.plans);
    }

    public void addPlan(InvestmentPlan plan) {
        this.plans.add(plan);
    }

    public void removePlan(InvestmentPlan plan) {
        this.plans.remove(plan);
    }

    public List<Security> getSecurities() {
        return Collections.unmodifiableList(this.securities);
    }

    public List<Security> getActiveSecurities() {
        return this.securities.stream().filter(s -> s.getCurrencyCode() != null).filter(s -> !s.isRetired()).sorted(new Security.ByName()).collect(Collectors.toList());
    }

    public void addSecurity(Security security) {
        Objects.requireNonNull(security);
        this.securities.add(security);
        this.propertyChangeSupport.firePropertyChange("securities", null, security);
    }

    public void removeSecurity(Security security) {
        for (Watchlist w : this.watchlists) {
            w.getSecurities().remove(security);
        }
        this.deleteInvestmentPlans(security);
        this.deleteTaxonomyAssignments(security);
        this.deleteAccountTransactions(security);
        this.deletePortfolioTransactions(security);
        this.securities.remove(security);
        this.propertyChangeSupport.firePropertyChange("securities", security, null);
    }

    public List<CurrencyUnit> getUsedCurrencies() {
        HashSet<String> hsUsedCodes = new HashSet<String>();
        hsUsedCodes.add(this.baseCurrency);
        for (Account account : this.accounts) {
            hsUsedCodes.add(account.getCurrencyCode());
        }
        for (Portfolio portfolio : this.portfolios) {
            for (PortfolioTransaction t : portfolio.getTransactions()) {
                hsUsedCodes.add(t.getCurrencyCode());
            }
        }
        for (Security security : this.securities) {
            hsUsedCodes.add(security.getCurrencyCode());
        }
        ArrayList<CurrencyUnit> lUnits = new ArrayList<CurrencyUnit>();
        for (String code : hsUsedCodes) {
            CurrencyUnit unit = CurrencyUnit.getInstance(code);
            if (unit == null) continue;
            lUnits.add(unit);
        }
        Collections.sort(lUnits);
        return lUnits;
    }

    public List<Watchlist> getWatchlists() {
        return this.watchlists;
    }

    @Deprecated
    List<ConsumerPriceIndex> getConsumerPriceIndices() {
        return Collections.unmodifiableList(this.consumerPriceIndeces);
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
    }

    public void removeAccount(Account account) {
        this.deleteReferenceAccount(account);
        this.deleteTransactions(account);
        this.deleteInvestmentPlans(account);
        this.deleteTaxonomyAssignments(account);
        this.accounts.remove(account);
    }

    public List<Account> getAccounts() {
        return Collections.unmodifiableList(this.accounts);
    }

    public List<Account> getActiveAccounts() {
        return this.accounts.stream().filter(a -> !a.isRetired()).sorted(new Named.ByName()).collect(Collectors.toList());
    }

    public void addPortfolio(Portfolio portfolio) {
        this.portfolios.add(portfolio);
    }

    public void removePortfolio(Portfolio portfolio) {
        this.deleteTransactions(portfolio);
        this.deleteInvestmentPlans(portfolio);
        this.portfolios.remove(portfolio);
    }

    public List<Portfolio> getPortfolios() {
        return Collections.unmodifiableList(this.portfolios);
    }

    public List<Portfolio> getActivePortfolios() {
        return this.portfolios.stream().filter(p -> !p.isRetired()).sorted(new Named.ByName()).collect(Collectors.toList());
    }

    @Deprecated
    Category getRootCategory() {
        return this.rootCategory;
    }

    @Deprecated
    void setRootCategory(Category rootCategory) {
        this.rootCategory = rootCategory;
    }

    @Deprecated
    String getIndustryTaxonomy() {
        return this.industryTaxonomyId;
    }

    @Deprecated
    void setIndustryTaxonomy(String industryTaxonomyId) {
        this.industryTaxonomyId = industryTaxonomyId;
    }

    public List<Taxonomy> getTaxonomies() {
        return Collections.unmodifiableList(this.taxonomies);
    }

    public void addTaxonomy(Taxonomy taxonomy) {
        this.taxonomies.add(taxonomy);
    }

    public void addTaxonomy(int index, Taxonomy taxonomy) {
        this.taxonomies.add(index, taxonomy);
    }

    public void removeTaxonomy(Taxonomy taxonomy) {
        this.taxonomies.remove(taxonomy);
    }

    public Taxonomy getTaxonomy(String id) {
        return this.taxonomies.stream().filter(t -> id.equals(t.getId())).findAny().orElse(null);
    }

    public Stream<Dashboard> getDashboards() {
        return this.dashboards.stream();
    }

    public void addDashboard(Dashboard dashboard) {
        this.dashboards.add(dashboard);
    }

    public void addDashboard(int index, Dashboard dashboard) {
        this.dashboards.add(index, dashboard);
    }

    public void removeDashboard(Dashboard dashboard) {
        this.dashboards.remove(dashboard);
    }

    public ClientSettings getSettings() {
        return this.settings;
    }

    public void setProperty(String key, String value) {
        String oldValue = this.properties.put(key, value);
        this.propertyChangeSupport.firePropertyChange("properties", oldValue, value);
    }

    public String removeProperty(String key) {
        String oldValue = this.properties.remove(key);
        this.propertyChangeSupport.firePropertyChange("properties", oldValue, null);
        return oldValue;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public int getPropertyInt(String key) {
        try {
            String v = this.properties.get(key);
            return v == null ? 0 : Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    void clearProperties() {
        this.properties.clear();
    }

    public List<TransactionPair<?>> getAllTransactions() {
        ArrayList transactions = new ArrayList();
        for (Portfolio portfolio : this.portfolios) {
            portfolio.getTransactions().stream().filter(t -> t.getType() != PortfolioTransaction.Type.TRANSFER_IN).map(t -> new TransactionPair<PortfolioTransaction>(portfolio, (PortfolioTransaction)t)).forEach(transactions::add);
        }
        EnumSet<AccountTransaction.Type> exclude = EnumSet.of(AccountTransaction.Type.TRANSFER_IN, AccountTransaction.Type.BUY, AccountTransaction.Type.SELL);
        for (Account account : this.accounts) {
            account.getTransactions().stream().filter(t -> !exclude.contains((Object)t.getType())).map(t -> new TransactionPair<AccountTransaction>(account, (AccountTransaction)t)).forEach(transactions::add);
        }
        return transactions;
    }

    SecretKey getSecret() {
        return this.secret;
    }

    void setSecret(SecretKey secret) {
        this.secret = secret;
    }

    private void deleteReferenceAccount(Account account) {
        for (Portfolio portfolio : this.portfolios) {
            if (!account.equals(portfolio.getReferenceAccount())) continue;
            portfolio.setReferenceAccount(null);
            this.accounts.stream().filter(a -> !account.equals(a)).findAny().ifPresent(portfolio::setReferenceAccount);
            if (portfolio.getReferenceAccount() != null) continue;
            Account referenceAccount = new Account();
            referenceAccount.setName(MessageFormat.format(Messages.LabelDefaultReferenceAccountName, portfolio.getName()));
            this.addAccount(referenceAccount);
            portfolio.setReferenceAccount(referenceAccount);
        }
    }

    private <T extends Transaction> void deleteTransactions(TransactionOwner<T> owner) {
        for (Transaction t : new ArrayList<T>(owner.getTransactions())) {
            owner.deleteTransaction(t, this);
        }
    }

    private void deleteInvestmentPlans(Portfolio portfolio) {
        for (InvestmentPlan plan : new ArrayList<InvestmentPlan>(this.plans)) {
            if (!portfolio.equals(plan.getPortfolio())) continue;
            this.removePlan(plan);
        }
    }

    private void deleteInvestmentPlans(Account account) {
        for (InvestmentPlan plan : new ArrayList<InvestmentPlan>(this.plans)) {
            if (!account.equals(plan.getAccount())) continue;
            this.removePlan(plan);
        }
    }

    private void deleteInvestmentPlans(Security security) {
        for (InvestmentPlan plan : new ArrayList<InvestmentPlan>(this.plans)) {
            if (!security.equals(plan.getSecurity())) continue;
            this.removePlan(plan);
        }
    }

    private void deleteTaxonomyAssignments(final InvestmentVehicle vehicle) {
        for (Taxonomy taxonomy : this.taxonomies) {
            taxonomy.foreach(new Taxonomy.Visitor(){

                @Override
                public void visit(Classification classification, Classification.Assignment assignment) {
                    if (vehicle.equals(assignment.getInvestmentVehicle())) {
                        classification.removeAssignment(assignment);
                    }
                }
            });
        }
    }

    private void deleteAccountTransactions(Security security) {
        for (Account account : this.accounts) {
            for (AccountTransaction t : new ArrayList<AccountTransaction>(account.getTransactions())) {
                if (t.getSecurity() == null || !security.equals(t.getSecurity())) continue;
                account.deleteTransaction(t, this);
            }
        }
    }

    private void deletePortfolioTransactions(Security security) {
        for (Portfolio portfolio : this.portfolios) {
            for (PortfolioTransaction t : new ArrayList<PortfolioTransaction>(portfolio.getTransactions())) {
                if (!security.equals(t.getSecurity())) continue;
                portfolio.deleteTransaction(t, this);
            }
        }
    }

    public void markDirty() {
        this.propertyChangeSupport.firePropertyChange("dirty", false, true);
    }

    public void touch() {
        this.propertyChangeSupport.firePropertyChange("touch", false, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String debugTransactionsToString() {
        StringBuilder answer = new StringBuilder();
        for (Portfolio portfolio : this.portfolios) {
            answer.append(portfolio.getName()).append('\n');
            portfolio.getTransactions().stream().sorted(new Transaction.ByDate()).forEach(t -> {
                StringBuilder stringBuilder2 = answer.append(t).append('\n');
            });
        }
        for (Account account : this.accounts) {
            answer.append(account.getName()).append('\n');
            account.getTransactions().stream().sorted(new Transaction.ByDate()).forEach(t -> {
                StringBuilder stringBuilder2 = answer.append(t).append('\n');
            });
        }
        return answer.toString();
    }
}

