/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.time.LocalDateTime;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.Money;

public class BuySellEntry
implements CrossEntry,
Annotated {
    private Portfolio portfolio;
    private PortfolioTransaction portfolioTransaction;
    private Account account;
    private AccountTransaction accountTransaction;

    public BuySellEntry() {
        this(null, null);
    }

    public BuySellEntry(Portfolio portfolio, Account account) {
        this.portfolio = portfolio;
        this.portfolioTransaction = new PortfolioTransaction();
        this.portfolioTransaction.setCrossEntry(this);
        this.account = account;
        this.accountTransaction = new AccountTransaction();
        this.accountTransaction.setCrossEntry(this);
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setDate(LocalDateTime date) {
        this.portfolioTransaction.setDateTime(date);
        this.accountTransaction.setDateTime(date);
    }

    public void setType(PortfolioTransaction.Type type) {
        this.portfolioTransaction.setType(type);
        this.accountTransaction.setType(AccountTransaction.Type.valueOf(type.name()));
    }

    public void setSecurity(Security security) {
        this.portfolioTransaction.setSecurity(security);
        this.accountTransaction.setSecurity(security);
    }

    public void setShares(long shares) {
        this.portfolioTransaction.setShares(shares);
    }

    public void setAmount(long amount) {
        this.portfolioTransaction.setAmount(amount);
        this.accountTransaction.setAmount(amount);
    }

    public void setCurrencyCode(String currencyCode) {
        this.portfolioTransaction.setCurrencyCode(currencyCode);
        this.accountTransaction.setCurrencyCode(currencyCode);
    }

    public void setMonetaryAmount(Money amount) {
        this.portfolioTransaction.setMonetaryAmount(amount);
        this.accountTransaction.setMonetaryAmount(amount);
    }

    @Override
    public String getNote() {
        return this.portfolioTransaction.getNote();
    }

    @Override
    public void setNote(String note) {
        this.portfolioTransaction.setNote(note);
        this.accountTransaction.setNote(note);
    }

    @Override
    public void insert() {
        this.portfolio.addTransaction(this.portfolioTransaction);
        this.account.addTransaction(this.accountTransaction);
    }

    @Override
    public void updateFrom(Transaction t) {
        if (t == this.accountTransaction) {
            this.portfolioTransaction.setDateTime(this.accountTransaction.getDateTime());
            this.portfolioTransaction.setSecurity(this.accountTransaction.getSecurity());
            this.portfolioTransaction.setNote(this.accountTransaction.getNote());
        } else if (t == this.portfolioTransaction) {
            this.accountTransaction.setDateTime(this.portfolioTransaction.getDateTime());
            this.accountTransaction.setSecurity(this.portfolioTransaction.getSecurity());
            this.accountTransaction.setNote(this.portfolioTransaction.getNote());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public TransactionOwner<? extends Transaction> getOwner(Transaction t) {
        if (t.equals(this.portfolioTransaction)) {
            return this.portfolio;
        }
        if (t.equals(this.accountTransaction)) {
            return this.account;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOwner(Transaction t, TransactionOwner<? extends Transaction> owner) {
        if (t.equals(this.portfolioTransaction) && owner instanceof Portfolio) {
            this.portfolio = (Portfolio)owner;
        } else if (t.equals(this.accountTransaction) && owner instanceof Account) {
            this.account = (Account)owner;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Transaction getCrossTransaction(Transaction t) {
        if (t.equals(this.portfolioTransaction)) {
            return this.accountTransaction;
        }
        if (t.equals(this.accountTransaction)) {
            return this.portfolioTransaction;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionOwner<? extends Transaction> getCrossOwner(Transaction t) {
        if (t.equals(this.portfolioTransaction)) {
            return this.account;
        }
        if (t.equals(this.accountTransaction)) {
            return this.portfolio;
        }
        throw new UnsupportedOperationException();
    }

    public PortfolioTransaction getPortfolioTransaction() {
        return this.portfolioTransaction;
    }

    public AccountTransaction getAccountTransaction() {
        return this.accountTransaction;
    }
}

