/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.ResourceBundle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;

public class AccountTransaction
extends Transaction {
    private Type type;

    public AccountTransaction() {
    }

    public AccountTransaction(LocalDateTime date, String currencyCode, long amount, Security security, Type type) {
        super(date, currencyCode, amount, security, 0L, null);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public long getGrossValueAmount() {
        long taxAndFees = this.getUnitSum(Transaction.Unit.Type.FEE, Transaction.Unit.Type.TAX).getAmount();
        return this.getAmount() + (this.type.isCredit() ? taxAndFees : -taxAndFees);
    }

    public Money getGrossValue() {
        return Money.of(this.getCurrencyCode(), this.getGrossValueAmount());
    }

    public String toString() {
        return String.format("%s %-17s %s %9s %s %s", Values.Date.format(this.getDateTime().toLocalDate()), this.type.name(), this.getCurrencyCode(), Values.Amount.format(this.getAmount()), this.getSecurity() != null ? this.getSecurity().getName() : "<no Security>", this.getCrossEntry() != null && this.getCrossEntry().getCrossOwner(this) != null ? this.getCrossEntry().getCrossOwner(this).toString() : "<no XEntry>");
    }

    public static final class ByDateAmountTypeAndHashCode
    implements Comparator<AccountTransaction>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(AccountTransaction t1, AccountTransaction t2) {
            int compare = t1.getDateTime().compareTo(t2.getDateTime());
            if (compare != 0) {
                return compare;
            }
            compare = Long.compare(t1.getAmount(), t2.getAmount());
            if (compare != 0) {
                return compare;
            }
            compare = t1.getType().compareTo(t2.getType());
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(t1.hashCode(), t2.hashCode());
        }
    }

    public static enum Type {
        DEPOSIT(false),
        REMOVAL(true),
        INTEREST(false),
        INTEREST_CHARGE(true),
        DIVIDENDS(false),
        FEES(true),
        FEES_REFUND(false),
        TAXES(true),
        TAX_REFUND(false),
        BUY(true),
        SELL(false),
        TRANSFER_IN(false),
        TRANSFER_OUT(true);

        private static final ResourceBundle RESOURCES;
        private final boolean isDebit;

        static {
            RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.model.labels");
        }

        private Type(boolean isDebit) {
            this.isDebit = isDebit;
        }

        public boolean isDebit() {
            return this.isDebit;
        }

        public boolean isCredit() {
            return !this.isDebit;
        }

        public String toString() {
            return RESOURCES.getString("account." + this.name());
        }
    }
}

