/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.TransactionOwner;

public class Account
implements TransactionOwner<AccountTransaction>,
InvestmentVehicle,
Attributable {
    private String uuid;
    private String name;
    private String currencyCode = "EUR";
    private String note;
    private boolean isRetired = false;
    private List<AccountTransaction> transactions = new ArrayList<AccountTransaction>();
    private Attributes attributes;

    public Account() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Account(String name) {
        this();
        this.name = name;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    void generateUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public boolean isRetired() {
        return this.isRetired;
    }

    @Override
    public void setRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public List<AccountTransaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void addTransaction(AccountTransaction transaction) {
        if (!this.currencyCode.equals(transaction.getCurrencyCode())) {
            throw new IllegalArgumentException();
        }
        this.transactions.add(transaction);
    }

    @Override
    public void shallowDeleteTransaction(AccountTransaction transaction, Client client) {
        this.transactions.remove(transaction);
        client.getPlans().stream().forEach(plan -> plan.removeTransaction(transaction));
    }

    public long getCurrentAmount(LocalDateTime date) {
        return this.transactions.stream().filter(t -> t.getDateTime().isBefore(date)).mapToLong(t -> {
            switch (t.getType()) {
                case DEPOSIT: 
                case INTEREST: 
                case DIVIDENDS: 
                case FEES_REFUND: 
                case TAX_REFUND: 
                case SELL: 
                case TRANSFER_IN: {
                    return t.getAmount();
                }
                case REMOVAL: 
                case INTEREST_CHARGE: 
                case FEES: 
                case TAXES: 
                case BUY: 
                case TRANSFER_OUT: {
                    return -t.getAmount();
                }
            }
            throw new UnsupportedOperationException();
        }).sum();
    }

    public String toString() {
        return this.getName();
    }
}

