/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.math;

import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.math.NewtonGoalSeek;
import name.abuchen.portfolio.util.Dates;

class NPVFunction
implements NewtonGoalSeek.Function {
    private final int[] days;
    private final double[] values;

    public NPVFunction(List<LocalDate> dates, List<Double> values) {
        if (dates == null || values == null) {
            throw new NullPointerException("dates and/or values are null");
        }
        if (dates.size() != values.size()) {
            throw new UnsupportedOperationException("dates and values must have equal size.");
        }
        if (dates.isEmpty() || values.isEmpty()) {
            throw new UnsupportedOperationException("at least one data point must be provided");
        }
        this.days = new int[dates.size()];
        int ii = 0;
        while (ii < dates.size()) {
            this.days[ii] = Dates.daysBetween(dates.get(0), dates.get(ii));
            ++ii;
        }
        this.values = new double[values.size()];
        ii = 0;
        while (ii < values.size()) {
            this.values[ii] = values.get(ii);
            ++ii;
        }
    }

    @Override
    public double compute(double rate) {
        double answer = 0.0;
        int ii = 0;
        while (ii < this.days.length) {
            answer += this.values[ii] / Math.pow(rate, (double)this.days[ii] / 365.0);
            ++ii;
        }
        return answer;
    }
}

