/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class SBrokerPDFExtractor
extends AbstractPDFExtractor {
    public SBrokerPDFExtractor(Client client) {
        super(client);
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
    }

    @Override
    public String getLabel() {
        return "S Broker AG & Co. KG";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Kauf .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name").find("Gattungsbezeichnung ISIN").match("(?<name>.*)\\W+(?<isin>.+)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date", "amount", "currency").find("Wert +Konto-Nr. Betrag zu Ihren Lasten *").match("(?<date>\\d+.\\d+.\\d{4}) \\d{2}/\\d{4}/\\d{3} (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("shares").match("^STK (?<shares>\\d+,\\d+?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("fee", "currency").optional().match(".* Orderentgelt\\W+(?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)-").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* B\u00f6rsengeb\u00fchr (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)-").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t)));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Verkauf .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name").find("Gattungsbezeichnung ISIN").match("(?<name>.*)\\W+(?<isin>.+)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date", "amount", "currency").find("Wert Konto-Nr. Betrag zu Ihren Gunsten").match("(?<date>\\d+.\\d+.\\d{4}) \\d{2}/\\d{4}/\\d{3} (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("shares").match("^STK (?<shares>\\d+,\\d+?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("fee", "currency").optional().match(".* Orderentgelt (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)-").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* B\u00f6rsengeb\u00fchr (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)-").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t)));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Ertr\u00e4gnisgutschrift");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Ertr\u00e4gnisgutschrift.*EMAILVERSAND.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("isin", "name").find("Gattungsbezeichnung ISIN").match("(?<name>.*)\\W+(?<isin>.+)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^STK (?<shares>\\d+,\\d+?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").find("Wert Konto-Nr. (Devisenkurs )?Betrag zu Ihren Gunsten").match("(?<date>\\d+.\\d+.\\d{4}).*(?<currency>\\w{3}) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }
}

