/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.SecurityCache;
import name.abuchen.portfolio.datatransfer.pdf.BaaderBankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.BankSLMPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.BondoraGoAndGrowPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.ComdirectPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.CommerzbankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.ConsorsbankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.ConsorsbankPre2009PDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DABPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DZBankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DegiroPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DeutscheBankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DkbPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.DreiBankenEDVPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.FinTechGroupBankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.HelloBankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.INGDiBaExtractor;
import name.abuchen.portfolio.datatransfer.pdf.JSONPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.JustTradePDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.OnvistaPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFInputFile;
import name.abuchen.portfolio.datatransfer.pdf.PostfinancePDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.QuirionPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.SBrokerPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.SutorPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.SwissquotePDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.TargobankPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.TradeRepublicPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.UnicreditPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.ViacPDFExtractor;
import name.abuchen.portfolio.model.Client;
import org.eclipse.core.runtime.IProgressMonitor;

public class PDFImportAssistant {
    private final Client client;
    private final List<File> files;
    private final List<Extractor> extractors = new ArrayList<Extractor>();

    public PDFImportAssistant(Client client, List<File> files) {
        this.client = client;
        this.files = files;
        this.extractors.add(new BaaderBankPDFExtractor(client));
        this.extractors.add(new BankSLMPDFExtractor(client));
        this.extractors.add(new BondoraGoAndGrowPDFExtractor(client));
        this.extractors.add(new ComdirectPDFExtractor(client));
        this.extractors.add(new CommerzbankPDFExtractor(client));
        this.extractors.add(new ConsorsbankPDFExtractor(client));
        this.extractors.add(new ConsorsbankPre2009PDFExtractor(client));
        this.extractors.add(new DABPDFExtractor(client));
        this.extractors.add(new DegiroPDFExtractor(client));
        this.extractors.add(new DeutscheBankPDFExtractor(client));
        this.extractors.add(new DkbPDFExtractor(client));
        this.extractors.add(new DreiBankenEDVPDFExtractor(client));
        this.extractors.add(new DZBankPDFExtractor(client));
        this.extractors.add(new FinTechGroupBankPDFExtractor(client));
        this.extractors.add(new HelloBankPDFExtractor(client));
        this.extractors.add(new INGDiBaExtractor(client));
        this.extractors.add(new JustTradePDFExtractor(client));
        this.extractors.add(new OnvistaPDFExtractor(client));
        this.extractors.add(new PostfinancePDFExtractor(client));
        this.extractors.add(new QuirionPDFExtractor(client));
        this.extractors.add(new SBrokerPDFExtractor(client));
        this.extractors.add(new SutorPDFExtractor(client));
        this.extractors.add(new SwissquotePDFExtractor(client));
        this.extractors.add(new TargobankPDFExtractor(client));
        this.extractors.add(new TradeRepublicPDFExtractor(client));
        this.extractors.add(new UnicreditPDFExtractor(client));
        this.extractors.add(new ViacPDFExtractor(client));
        this.extractors.add(new JSONPDFExtractor(client, "deutsche-bank-purchase.json"));
        this.extractors.add(new JSONPDFExtractor(client, "deutsche-bank-sale.json"));
        this.extractors.add(new JSONPDFExtractor(client, "ffb.json"));
        this.extractors.add(new JSONPDFExtractor(client, "trade-republic-dividends.json"));
        this.extractors.add(new JSONPDFExtractor(client, "trade-republic-investmentplan.json"));
        this.extractors.add(new JSONPDFExtractor(client, "ebase.json"));
        this.extractors.add(new JSONPDFExtractor(client, "postbank-purchase.json"));
        this.extractors.add(new JSONPDFExtractor(client, "weberbank-dividends.json"));
    }

    public Map<Extractor, List<Extractor.Item>> run(IProgressMonitor monitor, Map<File, List<Exception>> errors) {
        monitor.beginTask(Messages.PDFMsgExtracingFiles, this.files.size());
        List inputFiles = this.files.stream().map(PDFInputFile::new).collect(Collectors.toList());
        HashMap<Extractor, List<Extractor.Item>> itemsByExtractor = new HashMap<Extractor, List<Extractor.Item>>();
        SecurityCache securityCache = new SecurityCache(this.client);
        for (PDFInputFile inputFile : inputFiles) {
            monitor.setTaskName(inputFile.getName());
            try {
                inputFile.convertPDFtoText();
                boolean extracted = false;
                ArrayList<Exception> warnings = new ArrayList<Exception>();
                for (Extractor extractor : this.extractors) {
                    List<Extractor.Item> items = extractor.extract(securityCache, inputFile, warnings);
                    if (items.isEmpty()) continue;
                    extracted = true;
                    itemsByExtractor.computeIfAbsent(extractor, e -> new ArrayList()).addAll(items);
                    break;
                }
                if (!extracted) {
                    Predicate<Exception> isNotUnsupportedOperation = e -> !(e instanceof UnsupportedOperationException);
                    List meaningfulExceptions = warnings.stream().filter(isNotUnsupportedOperation).collect(Collectors.toList());
                    errors.put(inputFile.getFile(), meaningfulExceptions.isEmpty() ? warnings : meaningfulExceptions);
                }
            }
            catch (IOException e2) {
                errors.computeIfAbsent(inputFile.getFile(), f -> new ArrayList()).add(e2);
            }
            monitor.worked(1);
        }
        itemsByExtractor.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Extractor)e.getKey()).postProcessing((List)e.getValue())));
        securityCache.addMissingSecurityItems(itemsByExtractor);
        return itemsByExtractor;
    }

    public List<Extractor.Item> runWithPlainText(File file, List<Exception> errors) throws FileNotFoundException {
        String extractedText = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scanner scanner = new Scanner(file, StandardCharsets.UTF_8.name());){
            extractedText = scanner.useDelimiter("\\A").next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        PDFInputFile inputFile = new PDFInputFile(file, extractedText);
        return this.runWithInputFile(inputFile, errors);
    }

    public List<Extractor.Item> runWithInputFile(PDFInputFile file, List<Exception> errors) throws FileNotFoundException {
        SecurityCache securityCache = new SecurityCache(this.client);
        List<Extractor.Item> items = null;
        for (Extractor extractor : this.extractors) {
            ArrayList<Exception> warnings;
            items = extractor.extract(securityCache, file, warnings = new ArrayList<Exception>());
            if (!items.isEmpty()) {
                errors.clear();
                errors.addAll(warnings);
                items = extractor.postProcessing(items);
                break;
            }
            errors.addAll(warnings);
        }
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Extractor, List<Extractor.Item>> itemsByExtractor = new HashMap<Extractor, List<Extractor.Item>>();
        itemsByExtractor.put(this.extractors.get(0), items);
        securityCache.addMissingSecurityItems(itemsByExtractor);
        return items;
    }
}

