/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

class PDFExtractorUtils {
    PDFExtractorUtils() {
    }

    public static void checkAndSetTax(Money tax, Transaction t, PDFParser.DocumentType type) {
        if (tax.getCurrencyCode().equals(t.getCurrencyCode())) {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
        } else if (type.getCurrentContext().containsKey("exchangeRate")) {
            BigDecimal exchangeRate = new BigDecimal(type.getCurrentContext().get("exchangeRate"));
            BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            Money txTax = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(inverseRate).setScale(0, RoundingMode.HALF_UP).longValue());
            if (t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax));
            } else {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax, tax, inverseRate));
            }
        }
    }
}

