/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class JustTradePDFExtractor
extends AbstractPDFExtractor {
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("d LLL yyyy HH:mm:ss", Locale.GERMANY);

    public JustTradePDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("justTRADE");
        this.addBuyTransactionOld();
        this.addBuySellTransaction();
    }

    private String stripTrailing(String value) {
        int right = value.length();
        if (value.endsWith(" ")) {
            value = value.substring(0, right - 1);
        }
        if (right == 0) {
            return "";
        }
        return value;
    }

    @Override
    public String getPDFAuthor() {
        return "Sutor Bank";
    }

    private void addBuyTransactionOld() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapier Abrechnung Kauf");
        this.addDocumentTyp(type);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        PDFParser.Block firstRelevantLine = new PDFParser.Block("St\u00fcck .*");
        type.addBlock(firstRelevantLine);
        firstRelevantLine.set(pdfTransaction);
        pdfTransaction.section("shares", "name", "isin", "wkn").match("^St\u00fcck (?<shares>[\\d.,]+) (?<name>.*) (?<isin>\\S*) \\((?<wkn>\\S*)\\)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date").match("Schlusstag\\/\\-Zeit (?<date>.{10}) .*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("amount", "currency").match("Kurswert (?<amount>[0-9.]+(\\,[0-9]{2}))- (?<currency>[A-Z]{3})").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode((String)v.get("currency"));
        }).wrap(Extractor.BuySellEntryItem::new);
    }

    private void addBuySellTransaction() {
        PDFParser.DocumentType newType = new PDFParser.DocumentType("Transaktionsart: (Kauf|Verkauf)");
        this.addDocumentTyp(newType);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        PDFParser.Block firstRelevantLine = new PDFParser.Block("Produktbezeichnung - .*", "Ausmachender Betrag:.*");
        newType.addBlock(firstRelevantLine);
        firstRelevantLine.set(pdfTransaction);
        pdfTransaction.section("name", "isin", "currency").match("Produktbezeichnung - (?<name>.*)").match(".*").match("Internationale Wertpapierkennnummer \\(ISIN\\): (?<isin>\\S*)").match("W\u00e4hrung: (?<currency>[A-Z]{3})").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            newType.getCurrentContext().put("currency", (String)v.get("currency"));
        }).section("date", "time").match("Orderausf\u00fchrung Datum\\/Zeit: (?<date>.{11}).*(?<time>.{8}).*").assign((t, v) -> {
            LocalDateTime dateTime = LocalDateTime.parse(String.format("%s %s", this.stripTrailing((String)v.get("date")), v.get("time")), DATE_TIME_FORMAT);
            t.setDate(dateTime);
        }).section("type").match("Transaktionsart: (?<type>\\w*)").assign((t, v) -> {
            if (((String)v.get("type")).equals("Verkauf")) {
                t.setType(PortfolioTransaction.Type.SELL);
            }
        }).section("shares").match("St\u00fcck\\/Nominale: (?<shares>[0-9.]+(\\,[0-9]{2})).*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount").match("Ausmachender Betrag: (\\W{1})(?<amount>([0-9.]+)\\,([0-9]{2}))").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(newType.getCurrentContext().get("currency")));
        }).section("tax").optional().match("Kapitalertragssteuer: (\\W{1})(?<tax>([0-9.]+)\\,([0-9]{2}))").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode(newType.getCurrentContext().get("currency")), this.asAmount((String)v.get("tax")))))).section("tax").optional().match("Solidarit\u00e4tszuschlag: (\\W{1})(?<tax>([0-9.]+)\\,([0-9]{2}))").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode(newType.getCurrentContext().get("currency")), this.asAmount((String)v.get("tax")))))).section("tax").optional().match("Kirchensteuer: (\\W{1})(?<tax>([0-9.]+)\\,([0-9]{2}))").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode(newType.getCurrentContext().get("currency")), this.asAmount((String)v.get("tax")))))).wrap(Extractor.BuySellEntryItem::new);
    }

    @Override
    public String getLabel() {
        return "Sutor justTRADE";
    }
}

