/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class DZBankPDFExtractor
extends AbstractPDFExtractor {
    public DZBankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Volksbank");
        this.addBankIdentifier("VRB Oberbayern");
        this.addBankIdentifier("NIBC Direct Depotservice");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addAusschuettungTransaction();
    }

    @Override
    public String getLabel() {
        return "DZBank";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapier Abrechnung Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapier Abrechnung Kauf.*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("date", "time").match("(Schlusstag/-Zeit) (?<date>\\d+.\\d+.\\d{4}+) (?<time>\\d+:\\d+).*").assign((t, v) -> {
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("shares", "name", "isin", "wkn").match("(Nominale Wertpapierbezeichnung ISIN \\(WKN\\))").match("(St.ck) (?<shares>[\\d.]+(,\\d+)?) (?<name>.*)\\s+(?<isin>.*) \\((?<wkn>.*)\\).*").assign((t, v) -> {
            v.put("isin", (String)v.get("isin"));
            v.put("wkn", (String)v.get("wkn"));
            v.put("name", (String)v.get("name"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("(Ausmachender Betrag)[ ]*(?<amount>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match("(Provision)[ ]*(?<fee>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("(Transaktionsentgelt B\u00f6rse)[ ]*(?<fee>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("(\u00dcbertragungs-/Liefergeb.hr)[ ]*(?<fee>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> {
            if (t.getPortfolioTransaction().getDateTime() == null) {
                throw new IllegalArgumentException("Missing date");
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        block.set(pdfTransaction);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapier Abrechnung Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapier Abrechnung Verkauf.*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date", "time").match("(Schlusstag/-Zeit) (?<date>\\d+.\\d+.\\d{4}+) (?<time>\\d+:\\d+).*").assign((t, v) -> {
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("shares", "name", "isin", "wkn").match("(Nominale Wertpapierbezeichnung ISIN \\(WKN\\))").match("(St.ck) (?<shares>[\\d.]+(,\\d+)?) (?<name>.*)\\s+(?<isin>.*) \\((?<wkn>.*)\\).*").assign((t, v) -> {
            v.put("isin", (String)v.get("isin"));
            v.put("wkn", (String)v.get("wkn"));
            v.put("name", (String)v.get("name"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("(Ausmachender Betrag)[ ]*(?<amount>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match("(Provision)[ ]*(?<fee>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("(\u00dcbertragungs-/Liefergeb.hr)[ ]*(?<fee>(\\d)*(\\.)?(\\d)*,(\\d)*).* (?<currency>\\w{3}+).*").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match("(Kapitalertragsteuer) [\\d+,\\%]* auf [\\d,]* EUR (?<tax>[\\d+,.]*)- (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("(Solidarit\u00e4tszuschlag) [\\d+,\\%]* auf [\\d,]* EUR (?<tax>[\\d+,.]*)- (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(t -> {
            if (t.getPortfolioTransaction().getDateTime() == null) {
                throw new IllegalArgumentException("Missing date");
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        });
        block.set(pdfTransaction);
    }

    private void addAusschuettungTransaction() {
        PDFParser.DocumentType dividende = new PDFParser.DocumentType("Aussch\u00fcttung Investmentfonds");
        this.addDocumentTyp(dividende);
        PDFParser.Block block = new PDFParser.Block("Aussch.ttung Investmentfonds.*");
        dividende.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("date").match(".*(Wertstellung) (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("shares", "name", "isin", "wkn").match("(Nominale Wertpapierbezeichnung ISIN \\(WKN\\))").match("(St.ck) (?<shares>[\\d.]+(,\\d+)?) (?<name>.*)\\s+(?<isin>.*) \\((?<wkn>.*)\\).*").assign((t, v) -> {
            v.put("isin", (String)v.get("isin"));
            v.put("wkn", (String)v.get("wkn"));
            v.put("name", (String)v.get("name"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("currency", "amount").find("^(Aussch.ttung) (?<amountfx>[\\d.]+(,[\\d]+)?) (USD) (?<amount>[\\d.]+(,[\\d]+)?)\\+ (?<currency>.*)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("currency", "amountaftertax").find(".*(Ausmachender Betrag) (?<amountaftertax>[\\d.]+(,[\\d]+)?)\\+ (?<currency>.*)$").assign((t, v) -> {
            long gross = t.getAmount();
            long tax = gross - this.asAmount((String)v.get("amountaftertax"));
            if (tax > 0L) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), tax)));
            }
        }).wrap(Extractor.TransactionItem::new));
    }
}

