/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class ConsorsbankPre2009PDFExtractor
extends AbstractPDFExtractor {
    public ConsorsbankPre2009PDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("");
        this.addBuyTransaction2001();
        this.addSellTransaction2001();
    }

    @Override
    public String getPDFAuthor() {
        return "Consorsbank";
    }

    @Override
    public String getLabel() {
        return "Consorsbank (before 2009)";
    }

    private void addBuyTransaction2001() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("WERTPAPIERABRECHNUNG");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^ *(KAUF|Kauf|BEZUG|Bezug) +AM .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        pdfTransaction.section("wkn", "name", "currency").match("^.+WKN: (?<wkn>[^ ]{6}) *$").match("^ *(?<name>.*)$").match("^ *(KURSWERT|Kurswert|) *(?<currency>\\w{3}+) .*$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^ *ST *(?<shares>[\\d.]+(,\\d+)?).*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("^ *(KAUF|Kauf|BEZUG|Bezug) +AM (?<date>\\d+\\.\\d+\\.\\d{4}+)\\s+.*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), "05:00:00"))).section("amount", "currency").match("^ *(KURSWERT|Kurswert|) *(?<currency>\\w{3}+) +(?<amount>[\\d.]+,\\d+).*$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction2001(pdfTransaction);
    }

    private void addFeesSectionsTransaction2001(PDFParser.Transaction<BuySellEntry> pdfTransaction) {
        pdfTransaction.section("currency", "stockfees").optional().match("^ *(GRUNDGEBUEHR|COURTAGE) +(?<currency>\\w{3}+) +(?<stockfees>[\\d.]+,\\d+).*$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("stockfees")))))).section("currency", "brokerage").optional().match("^ *PROVISION +(?<currency>\\w{3}+) +(?<brokerage>[\\d.]+,\\d+).*$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("brokerage")))))).section("currency", "expenses").optional().match("^ *EIG\\.SPESEN +(?<currency>\\w{3}+) +(?<expenses>[\\d.]+,\\d+).*$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("expenses"))))));
    }

    private void addSellTransaction2001() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("WERTPAPIERABRECHNUNG");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^ *(VERKAUF|Verkauf) +AM .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        pdfTransaction.section("wkn", "name", "currency").match("^.*WKN: (?<wkn>[^ ]{6}) *$").match("^(?<name>.*)$").match("^ *(KURSWERT|Kurswert|) *(?<currency>\\w{3}+) .*$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^ *ST *(?<shares>[\\d.]+(,\\d+)?).*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("^ *(VERKAUF|Verkauf) +AM (?<date>\\d+\\.\\d+\\.\\d{4}+)\\s+.*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), "05:00:00"))).section("amount", "currency").match("^ *(KURSWERT|Kurswert|) *(?<currency>\\w{3}+) +(?<amount>[\\d.]+,\\d+).*$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction2001(pdfTransaction);
    }
}

