/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFExtractorUtils;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class ConsorsbankPDFExtractor
extends AbstractPDFExtractor {
    public ConsorsbankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Consorsbank");
        this.addBankIdentifier("Cortal Consors");
        this.addBuyTransaction();
        this.addPreemptiveBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
        this.addTaxAdjustmentTransaction();
        this.addVorabpauschaleTransaction();
        this.addNewDividendTransaction();
    }

    @Override
    public String getPDFAuthor() {
        return "Consorsbank";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("KAUF");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^KAUF AM .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        pdfTransaction.section("wkn", "isin", "name", "currency").find("(Wertpapier|Bezeichnung) WKN ISIN").match("^(?<name>.*) (?<wkn>[^ ]*) (?<isin>[^ ]*)$").match("(Kurs|Preis pro Anteil) ([\\d.]+,\\d+) (?<currency>\\w{3}).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Einheit Umsatz( F\\Dlligkeit)?").match("^ST (?<shares>[\\d.]+(,\\d+)?).*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "time").match("KAUF AM (?<date>\\d+\\.\\d+\\.\\d{4}+)\\s+UM (?<time>\\d+:\\d+):\\d+.*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))).oneOf(section -> section.attributes("amount", "currency").match("^Wert \\d+.\\d+.\\d{4} (?<currency>\\w{3}) (?<amount>[\\d\\.]+,\\d+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency").match("^zulasten Konto-Nr. \\d+ (?<amount>[\\d\\.]+,\\d+) (?<currency>\\w{3}+)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        })).section("forex", "exchangeRate", "currency", "amount").optional().match("umger. zum Devisenkurs *(?<forex>\\w{3}+) *(?<exchangeRate>[\\d.]+,\\d+) *(?<currency>\\w{3}+) *(?<amount>[\\d.]+,\\d+) *").assign((t, v) -> {
            String forex = this.asCurrencyCode((String)v.get("forex"));
            if (t.getPortfolioTransaction().getSecurity().getCurrencyCode().equals(forex)) {
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                BigDecimal reverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long amount = this.asAmount((String)v.get("amount"));
                long fxAmount = exchangeRate.multiply(BigDecimal.valueOf(amount)).setScale(0, RoundingMode.HALF_DOWN).longValue();
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(this.asCurrencyCode((String)v.get("currency")), amount), Money.of(forex, fxAmount), reverseRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addPreemptiveBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("BEZUG");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^BEZUG AM .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        pdfTransaction.section("wkn", "isin", "name", "currency").find("(Wertpapier|Bezeichnung) WKN ISIN").match("^(?<name>.*) (?<wkn>[^ ]*) (?<isin>[^ ]*)$").match("(Kurs|Preis pro Anteil) ([\\d.]+,\\d+) (?<currency>\\w{3}).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Einheit Umsatz( F\\Dlligkeit)?").match("^ST (?<shares>[\\d.]+(,\\d+)?).*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").match("Wert (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDate(this.asDate((String)v.get("date")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(VERKAUF|VERK. TEIL-/BEZUGSR)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^(VERKAUF|VERK. TEIL-/BEZUGSR.) AM .*$");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        pdfTransaction.section("wkn", "isin", "name", "currency").find("(Wertpapier|Bezeichnung) WKN ISIN").match("^(?<name>.*) (?<wkn>[^ ]*) (?<isin>[^ ]*)$").match("(Kurs|Preis pro Anteil) ([\\d.]+,\\d+) (?<currency>\\w{3}).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").find("Einheit Umsatz( F\\Dlligkeit)?").match("^ST (?<shares>[\\d.]+(,\\d+)?).*$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).oneOf(section -> section.attributes("date").match("VERK. TEIL-/BEZUGSR. AM (?<date>\\d{2}\\.\\d{2}\\.\\d{4}) .*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))), section -> section.attributes("date", "time").match("VERKAUF AM (?<date>\\d{2}\\.\\d{2}\\.\\d{4}) *UM (?<time>\\d{2}:\\d{2}:\\d{2}) .*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time"))))).oneOf(section -> section.attributes("amount", "currency").match("Wert \\d+.\\d+.\\d{4} (?<currency>\\w{3}) (?<amount>[\\d\\.]+,\\d+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency").match("zugunsten Konto-Nr. \\d+ (?<amount>[\\d\\.]+,\\d+) (?<currency>\\w{3})$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        })).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
        this.addTaxesSectionsTransaction(pdfTransaction, type);
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(DIVIDENDENGUTSCHRIFT|ERTRAGSGUTSCHRIFT)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(DIVIDENDENGUTSCHRIFT|ERTRAGSGUTSCHRIFT).*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("amount", "currency").match("BRUTTO *(?<currency>\\w{3}+) *(?<amount>[\\d.]+,\\d+) *").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("wkn", "name", "shares").match("ST *(?<shares>[\\d.]+(,\\d+)?) *WKN: *(?<wkn>\\S*) *").match("^(?<name>.*)$").assign((t, v) -> {
            v.put("currency", t.getCurrencyCode());
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("rate", "amount", "currency").optional().match("UMGER.ZUM DEV.-KURS *(?<rate>[\\d.]+,\\d+) *(?<currency>\\w{3}+) *(?<amount>[\\d.]+,\\d+) *").assign((t, v) -> {
            Money currentMonetaryAmount = t.getMonetaryAmount();
            BigDecimal rate = this.asExchangeRate((String)v.get("rate"));
            type.getCurrentContext().put("exchangeRate", rate.toPlainString());
            BigDecimal accountMoneyValue = BigDecimal.valueOf(t.getAmount()).divide(rate, RoundingMode.HALF_DOWN);
            String currencyCode = this.asCurrencyCode((String)v.get("currency"));
            t.setMonetaryAmount(Money.of(currencyCode, this.asAmount((String)v.get("amount"))));
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                Money accountMoney = Money.of(currencyCode, Math.round(accountMoneyValue.doubleValue()));
                BigDecimal inverseRate = BigDecimal.ONE.divide(rate, 10, RoundingMode.HALF_DOWN);
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, accountMoney, currentMonetaryAmount, inverseRate);
                t.addUnit(grossValue);
            }
        }).section("kapst", "currency").optional().multipleTimes().match("KAPST .*(?<currency>\\w{3}+) *(?<kapst>[\\d.]+,\\d+) *").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("kapst")))))).section("solz", "currency").optional().multipleTimes().match("SOLZ .*(?<currency>\\w{3}+) *(?<solz>[\\d.]+,\\d+) *").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode(currency), this.asAmount((String)v.get("solz")))));
            }
        }).section("qust", "currency", "forexcurrency", "forex").optional().match("QUST [\\d.]+,\\d+ *% *(?<currency>\\w{3}+) *(?<qust>[\\d.]+,\\d+) *(?<forexcurrency>\\w{3}+) *(?<forex>[\\d.]+,\\d+) *").assign((t, v) -> {
            Optional<Transaction.Unit> grossValueOption = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            Money money = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("qust")));
            if (grossValueOption.isPresent()) {
                Money forex = Money.of(this.asCurrencyCode((String)v.get("forexcurrency")), this.asAmount((String)v.get("forex")));
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money, forex, grossValueOption.get().getExchangeRate()));
            } else {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money));
            }
        }).section("date").match("WERT (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("currency", "amount").optional().match("WERT \\d+.\\d+.\\d{4}+ *(?<currency>\\w{3}+) *(?<amount>[\\d.]+,\\d+) *").assign((t, v) -> {
            String currencyCode = this.asCurrencyCode((String)v.get("currency"));
            Money money = Money.of(currencyCode, this.asAmount((String)v.get("amount")));
            t.setMonetaryAmount(money);
        }).section("currency", "forexpenses").optional().match("FREMDE SPESEN *(?<currency>\\w{3}+) *(?<forexpenses>[\\d.]+,\\d+) *").assign((t, v) -> {
            Optional<Transaction.Unit> grossValueOption = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            long forexAmount = this.asAmount((String)v.get("forexpenses"));
            if (grossValueOption.isPresent()) {
                BigDecimal exchangeRate = grossValueOption.get().getExchangeRate();
                long convertedMoney = Math.round(exchangeRate.multiply(BigDecimal.valueOf(forexAmount)).doubleValue());
                Money money = Money.of(t.getCurrencyCode(), convertedMoney);
                Money forex = Money.of(this.asCurrencyCode((String)v.get("currency")), forexAmount);
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money, forex, grossValueOption.get().getExchangeRate()));
            } else {
                BigDecimal exchangeRate = new BigDecimal(type.getCurrentContext().get("exchangeRate"));
                long convertedMoney = BigDecimal.valueOf(forexAmount).divide(exchangeRate, RoundingMode.HALF_UP).longValue();
                Money money = Money.of(t.getCurrencyCode(), convertedMoney);
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money));
            }
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : null));
    }

    private <T extends PDFParser.Transaction<?>> void addTaxesSectionsTransaction(T pdfTransaction, PDFParser.DocumentType type) {
        pdfTransaction.section("tax", "currency").optional().multipleTimes().match("^KAPST .*(?<currency>\\w{3}) *(?<tax>[\\d\\.]+,\\d+) *").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().multipleTimes().match("^SOLZ .*(?<currency>\\w{3}) *(?<tax>[\\d\\.]+,\\d+) *").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().multipleTimes().match("^KIST .*(?<currency>\\w{3}) *(?<tax>[\\d\\.]+,\\d+) *").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().match("^abzgl. Quellensteuer .* (\\w{3}) (?<tax>[\\d\\.]+,\\d+) (?<currency>\\w{3})$").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().multipleTimes().match("^abzgl. Kapitalertrags(s)?teuer.* (?<tax>[\\d\\.]+,\\d+) (?<currency>\\w{3})$").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().multipleTimes().match("^abzgl. Solidarit\u00e4tszuschlag.* (?<tax>[\\d\\.]+,\\d+) (?<currency>\\w{3})$").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type)).section("tax", "currency").optional().multipleTimes().match("^abzgl. Kirchensteuer.* (?<tax>[\\d\\.]+,\\d{2}) (?<currency>\\w{3})$").assign((t, v) -> this.processTaxEntries(t, (Map<String, String>)v, type));
    }

    private void processTaxEntries(Object t, Map<String, String> v, PDFParser.DocumentType type) {
        if (t instanceof Transaction) {
            Money tax = Money.of(this.asCurrencyCode(v.get("currency")), this.asAmount(v.get("tax")));
            PDFExtractorUtils.checkAndSetTax(tax, (Transaction)t, type);
        } else {
            Money tax = Money.of(this.asCurrencyCode(v.get("currency")), this.asAmount(v.get("tax")));
            PDFExtractorUtils.checkAndSetTax(tax, ((BuySellEntry)t).getPortfolioTransaction(), type);
        }
    }

    private void addFeesSectionsTransaction(PDFParser.Transaction<BuySellEntry> pdfTransaction) {
        pdfTransaction.section("currency", "currency1", "fee").optional().match("(^.*)(B.rsenplatzgeb.hr)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Provision)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Handelsentgelt)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Transaktionsentgelt)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Grundgeb.hr)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Eig\\. Spesen)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        }).section("currency", "currency1", "tax").optional().match("(^.*)(Franzoesische Finanztransaktionssteuer [\\d\\,]+%)(?<currency>\\s\\w{3}\\s|\\s)?(?<tax>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currency, this.asAmount((String)v.get("tax")))));
        }).section("currency", "currency1", "fee").optional().match("(^.*)(Consorsbank Ausgabegeb.hr [\\d\\,]+%)(?<currency>\\s\\w{3}\\s|\\s)?(?<fee>[\\d\\.]+(,\\d{2})?)(?<currency1>\\s\\w{3}|$)?").assign((t, v) -> {
            String currency = ((String)v.get("currency")).trim().length() > 0 ? this.asCurrencyCode((String)v.get("currency")) : this.asCurrencyCode((String)v.get("currency1"));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(currency, this.asAmount((String)v.get("fee")))));
        });
    }

    private void addTaxAdjustmentTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Nachtr\u00e4gliche Verlustverrechnung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(" Erstattung/Belastung \\(-\\) von Steuern");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            t.setCurrencyCode("EUR");
            return t;
        }).section("date").optional().match(" *Den Steuerausgleich buchen wir mit Wertstellung (?<date>\\d+.\\d+.\\d{4}) .*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("amount", "sign").find(" *Erstattung/Belastung \\(-\\) von Steuern *").find(" *=* *").match(" *(?<amount>[\\d.]+,\\d{2})(?<sign>-?).*").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            if ("-".equals(v.get("sign"))) {
                t.setType(AccountTransaction.Type.TAXES);
            }
        }).wrap(t -> {
            if (t.getDateTime() == null) {
                if (t.getAmount() == 0L) {
                    return new Extractor.NonImportableItem("Erstattung/Belastung von Steuern mit 0 Euro");
                }
                throw new IllegalArgumentException(Messages.MsgErrorMissingDate);
            }
            return new Extractor.TransactionItem((AccountTransaction)t);
        }));
    }

    private void addNewDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(Dividendengutschrift|Ertragsgutschrift)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Dividendengutschrift|Ertragsgutschrift).*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        block.set(pdfTransaction);
        pdfTransaction.subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        });
        pdfTransaction.section("name", "wkn", "isin", "currency").find("Wertpapierbezeichnung WKN ISIN").match("(?<name>.*) (?<wkn>[^ ]*) (?<isin>[^ ]*)$").match(".*(Dividende pro St.ck|Ertragsaussch.ttung je Anteil) ([\\d.]+,\\d+) (?<currency>\\w{3}+).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("amount", "currency").match("Netto.* zugunsten IBAN (.*) (?<amount>[\\d.]+,\\d+) (?<currency>\\w{3}+)$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("shares").match("(?<shares>[\\d.]+(,\\d+)?) St\u00fcck").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("Valuta (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("exchangeRate", "fxAmount", "fxCurrency", "amount", "currency").optional().match("Brutto in (\\w{3}+) (?<fxAmount>[\\d.]+,\\d+) (?<fxCurrency>\\w{3}+)").match("Devisenkurs (?<exchangeRate>[\\d.]+,\\d+) (\\w{3}+) / (\\w{3}+)").match("Brutto in (\\w{3}+) (?<amount>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            if (t.getCurrencyCode().contentEquals(this.asCurrencyCode((String)v.get("fxCurrency")))) {
                exchangeRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
            }
            type.getCurrentContext().put("exchangeRate", exchangeRate.toPlainString());
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                Transaction.Unit grossValue;
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                if (!this.asCurrencyCode((String)v.get("fxCurrency")).equals(t.getCurrencyCode())) {
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                } else {
                    Money amount = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), this.asAmount((String)v.get("fxAmount")));
                    Money fxAmount = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
                    grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, amount, fxAmount, inverseRate);
                }
                t.addUnit(grossValue);
            }
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : null);
        this.addTaxesSectionsTransaction(pdfTransaction, type);
    }

    private void addVorabpauschaleTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Vorabpauschale");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Vorabpauschale");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> vorabpauschaleTransaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAXES);
            return entry;
        }).section("name", "wkn", "isin").match("Wertpapierbezeichnung WKN ISIN").match("(?<name>.*) (?<wkn>[^ ]*) (?<isin>[^ ]*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("tax", "currency", "date").optional().match("Netto zulasten .* (?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").match("Valuta (?<date>\\d+\\.\\d+\\.\\d{4}+) .*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : null);
        block.set(vorabpauschaleTransaction);
    }

    @Override
    public String getLabel() {
        return "Consorsbank";
    }
}

