/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.csv;

import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.CSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;

class CSVSecurityPriceExtractor
extends CSVExtractor {
    private List<CSVImporter.Field> fields = new ArrayList<CSVImporter.Field>();

    CSVSecurityPriceExtractor() {
        this.fields.add(new CSVImporter.DateField("date", Messages.CSVColumn_Date));
        this.fields.add(new CSVImporter.AmountField("quote", Messages.CSVColumn_Quote, "Schluss", "Schlusskurs", "Close"));
    }

    @Override
    public String getCode() {
        return "investment-vehicle-price";
    }

    @Override
    public String getLabel() {
        return Messages.CSVDefHistoricalQuotes;
    }

    @Override
    public List<CSVImporter.Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Extractor.Item> extract(int skipLines, List<String[]> rawValues, Map<String, CSVImporter.Column> field2column, List<Exception> errors) {
        Security dummy = new Security();
        for (String[] line : rawValues) {
            try {
                SecurityPrice p = this.extract(line, field2column);
                if (p.getValue() < 0L) continue;
                dummy.addPrice(p);
            }
            catch (ParseException e) {
                errors.add(e);
            }
        }
        ArrayList<Extractor.Item> result = new ArrayList<Extractor.Item>();
        if (!dummy.getPrices().isEmpty()) {
            result.add(new Extractor.SecurityItem(dummy));
        }
        return result;
    }

    private SecurityPrice extract(String[] rawValues, Map<String, CSVImporter.Column> field2column) throws ParseException {
        LocalDateTime date = this.getDate(Messages.CSVColumn_Date, null, rawValues, field2column);
        if (date == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Date), 0);
        }
        Long amount = this.getQuote(Messages.CSVColumn_Quote, rawValues, field2column);
        if (amount == null) {
            throw new ParseException(MessageFormat.format(Messages.CSVImportMissingField, Messages.CSVColumn_Quote), 0);
        }
        return new SecurityPrice(date.toLocalDate(), Math.abs(amount));
    }
}

