/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;

public class SecurityCache {
    private static final Security DUPLICATE_SECURITY_MARKER = new Security();
    private static final List<String> MESSAGES = Arrays.asList(Messages.MsgErrorDuplicateISIN, Messages.MsgErrorDuplicateTicker, Messages.MsgErrorDuplicateWKN, Messages.MsgErrorDuplicateName);
    private final Client client;
    private final List<Map<String, Security>> localMaps = new ArrayList<Map<String, Security>>();

    public SecurityCache(Client client) {
        this.client = client;
        this.localMaps.add(client.getSecurities().stream().filter(s -> s.getIsin() != null && !s.getIsin().isEmpty()).collect(Collectors.toMap(Security::getIsin, s -> s, (l, r) -> DUPLICATE_SECURITY_MARKER)));
        this.localMaps.add(client.getSecurities().stream().filter(s -> s.getTickerSymbol() != null && !s.getTickerSymbol().isEmpty()).collect(Collectors.toMap(Security::getTickerSymbol, s -> s, (l, r) -> DUPLICATE_SECURITY_MARKER)));
        this.localMaps.add(client.getSecurities().stream().filter(s -> s.getWkn() != null && !s.getWkn().isEmpty()).collect(Collectors.toMap(Security::getWkn, s -> s, (l, r) -> DUPLICATE_SECURITY_MARKER)));
        this.localMaps.add(client.getSecurities().stream().filter(s -> s.getName() != null && !s.getName().isEmpty()).collect(Collectors.toMap(Security::getName, s -> s, (l, r) -> DUPLICATE_SECURITY_MARKER)));
    }

    public Security lookup(String isin, String tickerSymbol, String wkn, String name, Supplier<Security> creationFunction) {
        List<String> attributes = Arrays.asList(isin, tickerSymbol, wkn, name);
        int idOfAttributeWithDuplicateSecurities = -1;
        int ii = 0;
        while (ii < 3) {
            String attribute = attributes.get(ii);
            Security security = this.localMaps.get(ii).get(attribute);
            if (security != null && security != DUPLICATE_SECURITY_MARKER) {
                return security;
            }
            if (idOfAttributeWithDuplicateSecurities < 0 && security == DUPLICATE_SECURITY_MARKER) {
                idOfAttributeWithDuplicateSecurities = ii;
            }
            ++ii;
        }
        if (idOfAttributeWithDuplicateSecurities >= 0) {
            throw new IllegalArgumentException(MessageFormat.format(MESSAGES.get(idOfAttributeWithDuplicateSecurities), attributes.get(idOfAttributeWithDuplicateSecurities)));
        }
        Security security = this.lookupSecurityByName(isin, tickerSymbol, wkn, name);
        if (security != null) {
            return security;
        }
        security = creationFunction.get();
        security.setIsin(isin);
        security.setWkn(wkn);
        security.setTickerSymbol(tickerSymbol);
        security.setName(name);
        int ii2 = 0;
        while (ii2 < this.localMaps.size()) {
            String attribute = attributes.get(ii2);
            if (attribute != null) {
                this.localMaps.get(ii2).put(attribute, security);
            }
            ++ii2;
        }
        return security;
    }

    private Security lookupSecurityByName(String isin, String tickerSymbol, String wkn, String name) {
        Security security = this.localMaps.get(3).get(name);
        if (security == null || security == DUPLICATE_SECURITY_MARKER) {
            return null;
        }
        if (this.doNotMatchIfGiven(isin, security.getIsin())) {
            return null;
        }
        if (this.doNotMatchIfGiven(tickerSymbol, security.getTickerSymbol())) {
            return null;
        }
        if (this.doNotMatchIfGiven(wkn, security.getWkn())) {
            return null;
        }
        return security;
    }

    private boolean doNotMatchIfGiven(String attribute1, String attribute2) {
        return attribute1 != null && attribute2 != null && !attribute1.equalsIgnoreCase(attribute2);
    }

    public void addMissingSecurityItems(Map<Extractor, List<Extractor.Item>> extractor2items) {
        HashSet<Security> available = new HashSet<Security>();
        available.addAll(this.client.getSecurities());
        extractor2items.values().stream().flatMap(Collection::stream).filter(i -> i instanceof Extractor.SecurityItem).map(Extractor.Item::getSecurity).forEach(available::add);
        for (Map.Entry<Extractor, List<Extractor.Item>> entry : extractor2items.entrySet()) {
            for (Extractor.Item item : new ArrayList(entry.getValue())) {
                if (item instanceof Extractor.SecurityItem || item.getSecurity() == null || available.contains(item.getSecurity())) continue;
                entry.getValue().add(new Extractor.SecurityItem(item.getSecurity()));
                available.add(item.getSecurity());
            }
        }
    }
}

