/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.AbstractPortfolioIssue;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.money.Values;

class MissingBuySellAccountIssue
extends AbstractPortfolioIssue {
    public MissingBuySellAccountIssue(Client client, Portfolio portfolio, PortfolioTransaction transaction) {
        super(client, portfolio, transaction);
    }

    @Override
    public String getLabel() {
        return MessageFormat.format(Messages.IssueMissingBuySellInAccount, this.transaction.getType().toString(), Values.Share.format(this.transaction.getShares()), Values.Quote.format(this.transaction.getGrossPricePerShare()), this.transaction.getSecurity().getName());
    }

    @Override
    public List<QuickFix> getAvailableFixes() {
        ArrayList<QuickFix> answer = new ArrayList<QuickFix>();
        answer.add(new ConvertToDeliveryFix());
        if (this.portfolio.getReferenceAccount() != null) {
            answer.add(new CreateBuySellEntryFix(this.portfolio.getReferenceAccount()));
        }
        for (Account account : this.client.getAccounts()) {
            if (account.equals(this.portfolio.getReferenceAccount())) continue;
            answer.add(new CreateBuySellEntryFix(account));
        }
        answer.add(new DeleteTransactionFix<PortfolioTransaction>(this.client, this.portfolio, this.transaction));
        return answer;
    }

    private final class ConvertToDeliveryFix
    implements QuickFix {
        PortfolioTransaction.Type target;

        public ConvertToDeliveryFix() {
            if (MissingBuySellAccountIssue.this.transaction.getType() == PortfolioTransaction.Type.BUY) {
                this.target = PortfolioTransaction.Type.DELIVERY_INBOUND;
            } else if (MissingBuySellAccountIssue.this.transaction.getType() == PortfolioTransaction.Type.SELL) {
                this.target = PortfolioTransaction.Type.DELIVERY_OUTBOUND;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixConvertToDelivery, this.target.toString());
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixConvertToDeliveryDone, this.target.toString());
        }

        @Override
        public void execute() {
            PortfolioTransaction t = new PortfolioTransaction();
            t.setType(this.target);
            t.setCurrencyCode(MissingBuySellAccountIssue.this.transaction.getCurrencyCode());
            t.setDateTime(MissingBuySellAccountIssue.this.transaction.getDateTime());
            t.setSecurity(MissingBuySellAccountIssue.this.transaction.getSecurity());
            t.setShares(MissingBuySellAccountIssue.this.transaction.getShares());
            t.setAmount(MissingBuySellAccountIssue.this.transaction.getAmount());
            t.addUnits(MissingBuySellAccountIssue.this.transaction.getUnits());
            MissingBuySellAccountIssue.this.portfolio.addTransaction(t);
            MissingBuySellAccountIssue.this.portfolio.getTransactions().remove(MissingBuySellAccountIssue.this.transaction);
        }
    }

    private final class CreateBuySellEntryFix
    implements QuickFix {
        private Account account;

        private CreateBuySellEntryFix(Account account) {
            this.account = account;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixCreateCrossEntryAccount, this.account.getName());
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixCreateCrossEntryDone, MissingBuySellAccountIssue.this.transaction.getType().toString());
        }

        @Override
        public void execute() {
            BuySellEntry entry = new BuySellEntry(MissingBuySellAccountIssue.this.portfolio, this.account);
            entry.setCurrencyCode(MissingBuySellAccountIssue.this.transaction.getCurrencyCode());
            entry.setDate(MissingBuySellAccountIssue.this.transaction.getDateTime());
            entry.setType(MissingBuySellAccountIssue.this.transaction.getType());
            entry.setSecurity(MissingBuySellAccountIssue.this.transaction.getSecurity());
            entry.setShares(MissingBuySellAccountIssue.this.transaction.getShares());
            entry.setAmount(MissingBuySellAccountIssue.this.transaction.getAmount());
            entry.getPortfolioTransaction().addUnits(MissingBuySellAccountIssue.this.transaction.getUnits());
            entry.insert();
            MissingBuySellAccountIssue.this.portfolio.getTransactions().remove(MissingBuySellAccountIssue.this.transaction);
        }
    }
}

