/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.wizards.security.AbstractPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SecurityTaxonomyPage
extends AbstractPage {
    public static final String PAGE_NAME = "taxonomies";
    private final EditSecurityModel model;
    private final BindingHelper bindings;
    private ScrolledComposite scrolledComposite;
    private Font boldFont;
    private List<ValidationStatusProvider> validators = new ArrayList<ValidationStatusProvider>();

    public SecurityTaxonomyPage(EditSecurityModel model, BindingHelper bindings) {
        this.model = model;
        this.bindings = bindings;
        this.setTitle(Messages.LabelTaxonomies);
    }

    @Override
    public void createControl(Composite parent) {
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.boldFont = resources.createFont(FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1));
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.setControl((Control)this.scrolledComposite);
        final Composite container = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(container);
        this.scrolledComposite.setContent((Control)container);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.createTaxonomyPicker(container);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SecurityTaxonomyPage.this.scrolledComposite.setMinSize(container.computeSize(-1, -1));
            }
        });
    }

    private void createTaxonomySection(final Composite taxonomyPicker, final EditSecurityModel.TaxonomyDesignation designation) {
        Label label = new Label(taxonomyPicker, 0);
        label.setFont(this.boldFont);
        label.setText(designation.getTaxonomy().getName());
        boolean isFirst = designation.equals(this.model.getDesignations().get(0));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(1, 0x1000000).indent(0, isFirst ? 0 : 20).applyTo((Control)label);
        this.addBlock(taxonomyPicker, designation);
        Link link = new Link(taxonomyPicker, 4);
        link.setText(Messages.EditWizardMasterDataLinkNewCategory);
        GridDataFactory.fillDefaults().span(2, 1).indent(0, 5).align(1, 0x1000000).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSecurityModel.ClassificationLink link = new EditSecurityModel.ClassificationLink();
                link.setWeight(designation.getLinks().isEmpty() ? Classification.ONE_HUNDRED_PERCENT : 0);
                designation.getLinks().add(link);
                SecurityTaxonomyPage.this.recreateTaxonomyPicker(taxonomyPicker);
            }
        });
    }

    private void addBlock(Composite taxonomyPicker, EditSecurityModel.TaxonomyDesignation designation) {
        Label sumOfWeights = null;
        ArrayList<IObservableValue<Integer>> weightObservables = new ArrayList<IObservableValue<Integer>>();
        ArrayList classificationObservables = new ArrayList();
        if (designation.getLinks().size() == 1 && designation.getLinks().get(0).getWeight() == Classification.ONE_HUNDRED_PERCENT) {
            this.addSimpleBlock(taxonomyPicker, designation, designation.getLinks().get(0), classificationObservables);
        } else if (!designation.getLinks().isEmpty()) {
            for (EditSecurityModel.ClassificationLink link : designation.getLinks()) {
                this.addFullBlock(taxonomyPicker, designation, link, weightObservables, classificationObservables);
            }
            sumOfWeights = new Label(taxonomyPicker, 0);
            sumOfWeights.setText("");
            GridDataFactory.fillDefaults().span(2, 1).indent(0, 5).align(1, 0x1000000).applyTo((Control)sumOfWeights);
        }
        this.setupWeightMultiValidator(sumOfWeights, designation, weightObservables);
        this.setupClassificationMultiValidator(designation, classificationObservables);
    }

    private void addSimpleBlock(Composite picker, EditSecurityModel.TaxonomyDesignation designation, EditSecurityModel.ClassificationLink link, List<IObservableValue<?>> classificationObservables) {
        Composite block = new Composite(picker, 0);
        block.setBackground(picker.getBackground());
        block.setData((Object)link);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)block);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(block);
        this.addDropDown(block, designation, classificationObservables);
        this.addDeleteButton(block, designation, link);
    }

    private void addFullBlock(Composite picker, EditSecurityModel.TaxonomyDesignation designation, EditSecurityModel.ClassificationLink link, List<IObservableValue<Integer>> weightObservables, List<IObservableValue<?>> classificationObservables) {
        Composite block = new Composite(picker, 0);
        block.setData((Object)link);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)block);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(block);
        this.addSpinner(block, link, weightObservables);
        this.addDropDown(block, designation, classificationObservables);
        this.addDeleteButton(block, designation, link);
    }

    private void recreateTaxonomyPicker(Composite taxonomyPicker) {
        for (ValidationStatusProvider validator : this.validators) {
            if (validator instanceof Binding) {
                this.bindings.getBindingContext().removeBinding((Binding)validator);
                continue;
            }
            this.bindings.getBindingContext().removeValidationStatusProvider(validator);
        }
        this.validators.clear();
        Composite parent = taxonomyPicker.getParent();
        taxonomyPicker.dispose();
        this.createTaxonomyPicker(parent);
        parent.layout();
    }

    private void setupWeightMultiValidator(Label sumOfWeights, EditSecurityModel.TaxonomyDesignation designation, List<IObservableValue<Integer>> weightObservables) {
        WeightsAreGreaterThan100Validator multiValidator = new WeightsAreGreaterThan100Validator(sumOfWeights, designation.getTaxonomy(), weightObservables);
        this.bindings.getBindingContext().addValidationStatusProvider((ValidationStatusProvider)multiValidator);
        this.validators.add((ValidationStatusProvider)multiValidator);
        int ii = 0;
        while (ii < weightObservables.size()) {
            IObservableValue<Integer> observable = weightObservables.get(ii);
            EditSecurityModel.ClassificationLink link = designation.getLinks().get(ii);
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setAfterConvertValidator((IValidator)new GreaterThanZeroValidator());
            IObservableValue targetObservable = multiValidator.observeValidatedValue(observable);
            IObservableValue weightObservable = BeanProperties.value((String)"weight", Integer.class).observe((Object)link);
            this.validators.add((ValidationStatusProvider)this.bindings.getBindingContext().bindValue(targetObservable, weightObservable, strategy, null));
            ++ii;
        }
    }

    private void setupClassificationMultiValidator(EditSecurityModel.TaxonomyDesignation designation, List<IObservableValue<?>> classificationObservables) {
        ClassificationNotTwiceValidator multiValidator = new ClassificationNotTwiceValidator(classificationObservables);
        this.bindings.getBindingContext().addValidationStatusProvider((ValidationStatusProvider)multiValidator);
        this.validators.add((ValidationStatusProvider)multiValidator);
        int ii = 0;
        while (ii < classificationObservables.size()) {
            IObservableValue<?> observable = classificationObservables.get(ii);
            EditSecurityModel.ClassificationLink link = designation.getLinks().get(ii);
            UpdateValueStrategy strategy = new UpdateValueStrategy();
            strategy.setAfterConvertValidator((IValidator)new NotNullValidator());
            IObservableValue classificationObservable = BeanProperties.value((String)"classification").observe((Object)link);
            this.validators.add((ValidationStatusProvider)this.bindings.getBindingContext().bindValue(multiValidator.observeValidatedValue(observable), classificationObservable, strategy, null));
            ++ii;
        }
    }

    private void addDropDown(Composite block, EditSecurityModel.TaxonomyDesignation designation, List<IObservableValue<?>> classificationObservables) {
        ComboViewer combo = new ComboViewer(block, 8);
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Classification)element).getPathName(false, 80);
            }
        });
        combo.setInput(designation.getElements());
        GridDataFactory.fillDefaults().grab(false, false).applyTo(combo.getControl());
        classificationObservables.add((IObservableValue<?>)ViewerProperties.singleSelection().observe((Viewer)combo));
    }

    private void addDeleteButton(final Composite block, final EditSecurityModel.TaxonomyDesignation designation, final EditSecurityModel.ClassificationLink link) {
        Button deleteButton = new Button(block, 8);
        deleteButton.setImage(Images.REMOVE.image());
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                designation.getLinks().remove(link);
                SecurityTaxonomyPage.this.recreateTaxonomyPicker(block.getParent());
            }
        });
    }

    private void addSpinner(Composite block, EditSecurityModel.ClassificationLink link, List<IObservableValue<Integer>> observables) {
        Spinner spinner = new Spinner(block, 2048);
        spinner.setDigits(2);
        spinner.setMinimum(0);
        spinner.setValues(link.getWeight(), 0, Classification.ONE_HUNDRED_PERCENT, 2, 100, 1000);
        GridDataFactory.fillDefaults().applyTo((Control)spinner);
        ISWTObservableValue observable = WidgetProperties.spinnerSelection().observe((Widget)spinner);
        observables.add((IObservableValue<Integer>)observable);
    }

    private void createTaxonomyPicker(Composite container) {
        Composite taxonomyPicker = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)taxonomyPicker);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(taxonomyPicker);
        for (EditSecurityModel.TaxonomyDesignation designation : this.model.getDesignations()) {
            this.createTaxonomySection(taxonomyPicker, designation);
        }
        this.scrolledComposite.setMinSize(container.computeSize(-1, -1));
    }

    private static final class ClassificationNotTwiceValidator
    extends MultiValidator {
        private final List<IObservableValue<?>> observables;

        private ClassificationNotTwiceValidator(List<IObservableValue<?>> observables) {
            this.observables = observables;
        }

        protected IStatus validate() {
            if (this.observables.isEmpty()) {
                return ValidationStatus.ok();
            }
            HashSet<Classification> selected = new HashSet<Classification>();
            for (IObservableValue<?> value : this.observables) {
                Classification classification = (Classification)value.getValue();
                if (selected.add(classification)) continue;
                return ValidationStatus.error((String)MessageFormat.format(Messages.EditWizardMasterDataMsgDuplicateClassification, classification.getName()));
            }
            return ValidationStatus.ok();
        }
    }

    private static final class GreaterThanZeroValidator
    implements IValidator<Integer> {
        private GreaterThanZeroValidator() {
        }

        public IStatus validate(Integer value) {
            int weight = value;
            return weight > 0 ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.EditWizardMasterDataMsgWeightEqualsZero);
        }
    }

    private static final class NotNullValidator
    implements IValidator<Object> {
        private NotNullValidator() {
        }

        public IStatus validate(Object value) {
            return value != null ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.EditWizardMasterDataMsgClassificationMissing);
        }
    }

    private static final class WeightsAreGreaterThan100Validator
    extends MultiValidator {
        private final Label label;
        private final Taxonomy taxonomy;
        private final List<IObservableValue<Integer>> observables;

        private WeightsAreGreaterThan100Validator(Label label, Taxonomy taxonomy, List<IObservableValue<Integer>> weightObservables) {
            this.label = label;
            this.taxonomy = taxonomy;
            this.observables = weightObservables;
        }

        protected IStatus validate() {
            if (this.observables.isEmpty()) {
                return ValidationStatus.ok();
            }
            int weights = 0;
            for (IObservableValue<Integer> value : this.observables) {
                weights += ((Integer)value.getValue()).intValue();
            }
            if (this.label != null) {
                this.label.setText(String.valueOf(Values.Weight.format((Object)weights)) + "%");
            }
            if (Classification.ONE_HUNDRED_PERCENT >= weights) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)MessageFormat.format(Messages.EditWizardMasterDataMsgWeightNot100Percent, this.taxonomy.getName(), Values.Weight.format((Object)weights)));
        }
    }
}

