/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.text.MessageFormat;
import java.util.Objects;
import javax.inject.Inject;
import name.abuchen.portfolio.events.SecurityChangeEvent;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.wizards.security.AbstractPage;
import name.abuchen.portfolio.ui.wizards.security.AttributesPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import name.abuchen.portfolio.ui.wizards.security.HistoricalQuoteProviderPage;
import name.abuchen.portfolio.ui.wizards.security.LatestQuoteProviderPage;
import name.abuchen.portfolio.ui.wizards.security.SecurityMasterDataPage;
import name.abuchen.portfolio.ui.wizards.security.SecurityTaxonomyPage;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EditSecurityDialog
extends Dialog {
    @Inject
    private IEventBroker eventBroker;
    private CTabFolder tabFolder;
    private Label errorMessage;
    private final EditSecurityModel model;
    private final BindingHelper bindings;
    private boolean showQuoteConfigurationInitially = false;

    @Inject
    public EditSecurityDialog(Shell parentShell, Client client, Security security) {
        super(parentShell);
        this.model = new EditSecurityModel(client, security);
        this.bindings = new BindingHelper(this.model){

            @Override
            public void onValidationStatusChanged(IStatus status) {
                Button button;
                boolean isOK;
                boolean bl = isOK = status.getSeverity() == 0;
                if (EditSecurityDialog.this.errorMessage != null && !EditSecurityDialog.this.errorMessage.isDisposed()) {
                    EditSecurityDialog.this.errorMessage.setText(isOK ? "" : status.getMessage());
                }
                if ((button = EditSecurityDialog.this.getButton(0)) != null && !button.isDisposed()) {
                    button.setEnabled(isOK);
                }
            }
        };
    }

    public void setShowQuoteConfigurationInitially(boolean showQuoteConfigurationInitially) {
        this.showQuoteConfigurationInitially = showQuoteConfigurationInitially;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.model.getName() != null ? this.model.getName() : Messages.NewFileWizardSecurityTitle);
    }

    protected Point getInitialSize() {
        Point preferredSize = this.getShell().computeSize(-1, -1, true);
        preferredSize.x = Math.min(Math.max(preferredSize.x, 700), 1000);
        preferredSize.y = Math.min(Math.max(preferredSize.y, 500), 700);
        return preferredSize;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setEnabled("".equals(this.errorMessage.getText()));
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(container);
        this.createUpperArea(container);
        this.createTabFolder(container);
        return container;
    }

    private void createUpperArea(Composite container) {
        Composite header = new Composite(container, 0);
        header.setBackground(container.getDisplay().getSystemColor(1));
        header.setLayout((Layout)new FormLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)header);
        Label lblName = new Label(header, 0);
        lblName.setText(Messages.ColumnName);
        lblName.setBackground(header.getBackground());
        Text name = new Text(header, 2048);
        name.setBackground(header.getBackground());
        this.errorMessage = new Label(header, 0);
        this.errorMessage.setForeground(Colors.theme().redForeground());
        this.errorMessage.setBackground(header.getBackground());
        Label imageLabel = new Label(header, 0);
        imageLabel.setBackground(header.getBackground());
        imageLabel.setImage(Images.BANNER.image());
        FormDataFactory.startingWith((Control)imageLabel).right(new FormAttachment(100));
        FormDataFactory.startingWith((Control)lblName).left(new FormAttachment(0, 5)).top(new FormAttachment(0, 10)).thenRight((Control)name).right(new FormAttachment((Control)imageLabel, -10));
        FormDataFactory.startingWith((Control)this.errorMessage).left(new FormAttachment(0, 5)).top(new FormAttachment((Control)lblName, 10)).right(new FormAttachment((Control)imageLabel, -10));
        ISWTObservableValue targetName = WidgetProperties.text((int)24).observe((Widget)name);
        IObservableValue observable = BeanProperties.value((String)"name", String.class).observe((Object)this.model);
        this.bindings.getBindingContext().bindValue((IObservableValue)targetName, observable, new UpdateValueStrategy().setAfterConvertValidator(v -> v != null && v.trim().length() > 0 ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnName))), null);
    }

    private void createTabFolder(Composite container) {
        this.tabFolder = new CTabFolder(container, 0x800080);
        this.tabFolder.setBorderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tabFolder);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private AbstractPage current = null;

            public void widgetSelected(SelectionEvent e) {
                if (this.current != null) {
                    this.current.afterPage();
                }
                this.current = (AbstractPage)((CTabItem)e.item).getData();
                this.current.beforePage();
            }
        });
        this.addPage(new SecurityMasterDataPage(this.model, this.bindings), Images.SECURITY.image());
        this.addPage(new AttributesPage(this.model, this.bindings), null);
        this.addPage(new SecurityTaxonomyPage(this.model, this.bindings), null);
        this.addPage(new HistoricalQuoteProviderPage(this.model, this.bindings), null);
        this.addPage(new LatestQuoteProviderPage(this.model, this.bindings), null);
        this.tabFolder.setSelection(this.showQuoteConfigurationInitially ? 3 : 0);
        ((AbstractPage)this.tabFolder.getSelection().getData()).beforePage();
    }

    private void addPage(AbstractPage page, Image image) {
        page.createControl((Composite)this.tabFolder);
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setImage(image);
        item.setControl(page.getControl());
        item.setText(page.getTitle());
        item.setData((Object)page);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        MessageDialog dialog;
        ((AbstractPage)this.tabFolder.getSelection().getData()).afterPage();
        Security security = this.model.getSecurity();
        boolean hasQuotes = !security.getPrices().isEmpty();
        boolean feedChanged = !Objects.equals(this.model.getFeed(), security.getFeed());
        boolean tickerChanged = !Objects.equals(this.model.getTickerSymbol(), security.getTickerSymbol());
        boolean feedURLChanged = !Objects.equals(this.model.getFeedURL(), security.getFeedURL());
        boolean currencyChanged = !Objects.equals(this.model.getCurrencyCode(), security.getCurrencyCode());
        boolean quotesCanChange = feedChanged || tickerChanged || feedURLChanged || currencyChanged;
        this.model.applyChanges();
        this.eventBroker.post("security/edited", (Object)new SecurityChangeEvent(this.model.getClient(), security));
        if (hasQuotes && quotesCanChange && (dialog = new MessageDialog(this.getShell(), Messages.MessageDialogProviderChanged, null, Messages.MessageDialogProviderChangedText, 3, new String[]{Messages.MessageDialogProviderAnswerKeep, Messages.MessageDialogProviderAnswerReplace}, 0)).open() == 1) {
            security.removeAllPrices();
        }
        super.okPressed();
    }
}

