/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.security;

import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import name.abuchen.portfolio.model.Exchange;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.wizards.security.AbstractPage;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityModel;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractQuoteProviderPage
extends AbstractPage {
    private static final String YAHOO = "YAHOO";
    private static final String HTML = "HTML";
    private ComboViewer comboProvider;
    private Group grpQuoteFeed;
    private Label labelDetailData;
    private ComboViewer comboExchange;
    private Text textFeedURL;
    private Text textTicker;
    private Text textQuandlCode;
    private Label labelQuandlCloseColumnName;
    private Text textQuandlCloseColumnName;
    private Label labelJsonPathDate;
    private Text textJsonPathDate;
    private Label labelJsonPathClose;
    private Text textJsonPathClose;
    private PropertyChangeListener tickerSymbolPropertyChangeListener = e -> this.onTickerSymbolChanged();
    private final EditSecurityModel model;
    private final BindingHelper bindings;
    private String tickerSymbol;
    private Map<QuoteFeed, List<Exchange>> cacheExchanges = new HashMap<QuoteFeed, List<Exchange>>();

    protected AbstractQuoteProviderPage(EditSecurityModel model, BindingHelper bindings) {
        this.model = model;
        this.bindings = bindings;
    }

    protected final EditSecurityModel getModel() {
        return this.model;
    }

    protected abstract String getFeed();

    protected abstract void setFeed(String var1);

    protected abstract String getFeedURL();

    protected abstract void setFeedURL(String var1);

    protected abstract String getJSONDatePropertyName();

    protected abstract String getJSONClosePropertyName();

    protected abstract void setStatus(String var1);

    protected abstract void createSampleArea(Composite var1);

    protected abstract List<QuoteFeed> getAvailableFeeds();

    protected abstract QuoteFeed getQuoteFeedProvider(String var1);

    protected abstract void reinitCaches();

    protected abstract void clearSampleQuotes();

    protected abstract void showSampleQuotes(QuoteFeed var1, Exchange var2);

    @Override
    public void beforePage() {
        String path;
        QuoteFeed feed;
        if (!Objects.equals(this.tickerSymbol, this.model.getTickerSymbol())) {
            this.tickerSymbol = this.model.getTickerSymbol();
            this.cacheExchanges = new HashMap<QuoteFeed, List<Exchange>>();
            this.reinitCaches();
            new LoadExchangesJob().schedule();
        }
        if ((feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement()) != null && feed.getId() != null && feed.getId().indexOf(HTML) >= 0) {
            if (this.getFeedURL() == null || this.getFeedURL().length() == 0) {
                this.clearSampleQuotes();
            } else {
                this.showSampleQuotes(feed, null);
            }
        }
        if (this.textQuandlCode != null && !this.textQuandlCode.getText().equals(this.model.getFeedProperty("QUANDLCODE"))) {
            String code = this.model.getFeedProperty("QUANDLCODE");
            this.textQuandlCode.setText(code != null ? code : "");
        }
        if (this.textQuandlCloseColumnName != null && !this.textQuandlCloseColumnName.getText().equals(this.model.getFeedProperty("QUANDLCLOSE"))) {
            String columnName = this.model.getFeedProperty("QUANDLCLOSE");
            this.textQuandlCloseColumnName.setText(columnName != null ? columnName : "");
        }
        if (this.textJsonPathDate != null && !this.textJsonPathDate.getText().equals(this.model.getFeedProperty(this.getJSONDatePropertyName()))) {
            path = this.model.getFeedProperty(this.getJSONDatePropertyName());
            this.textJsonPathDate.setText(path != null ? path : "");
        }
        if (this.textJsonPathClose != null && !this.textJsonPathClose.getText().equals(this.model.getFeedProperty(this.getJSONClosePropertyName()))) {
            path = this.model.getFeedProperty(this.getJSONClosePropertyName());
            this.textJsonPathClose.setText(path != null ? path : "");
        }
    }

    @Override
    public void afterPage() {
        QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
        this.setFeed(feed.getId());
        if (this.comboExchange != null && feed.getId() != null && (feed.getId().startsWith(YAHOO) || feed.getId().equals("EUROSTATHICP"))) {
            Exchange exchange = (Exchange)((IStructuredSelection)this.comboExchange.getSelection()).getFirstElement();
            if (exchange != null) {
                this.model.setTickerSymbol(exchange.getId());
                this.tickerSymbol = exchange.getId();
                this.setFeedURL(null);
            }
        } else if (this.comboExchange != null && feed.getId() != null && feed.getId().equals("PORTFOLIO-REPORT")) {
            Exchange exchange = (Exchange)((IStructuredSelection)this.comboExchange.getSelection()).getFirstElement();
            this.model.setFeedProperty("PORTFOLIO-REPORT-MARKET", exchange != null ? exchange.getId() : null);
        } else if (this.textFeedURL != null) {
            this.setFeedURL(this.textFeedURL.getText());
        }
    }

    @Override
    public final void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        this.createProviderGroup(container);
        Composite buttonArea = new Composite(container, 0);
        buttonArea.setLayout((Layout)new RowLayout(512));
        this.createAdditionalButtons(buttonArea);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.grpQuoteFeed, 20, 128);
        data.left = new FormAttachment((Control)this.grpQuoteFeed, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment((Control)this.grpQuoteFeed, -10, 1024);
        buttonArea.setLayoutData((Object)data);
        Composite sampleArea = new Composite(container, 0);
        sampleArea.setLayout((Layout)new FillLayout());
        this.createSampleArea(sampleArea);
        data = new FormData();
        data.top = new FormAttachment((Control)this.grpQuoteFeed, 5);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        sampleArea.setLayoutData((Object)data);
        this.setupInitialData();
        this.comboProvider.addSelectionChangedListener(this::onFeedProviderChanged);
    }

    protected void createAdditionalButtons(Composite container) {
    }

    protected Security buildTemporarySecurity() {
        Security security = new Security();
        this.model.setAttributes(security);
        this.model.getSecurity().getProperties().forEach(arg_0 -> ((Security)security).addProperty(arg_0));
        return security;
    }

    private void createProviderGroup(Composite container) {
        this.grpQuoteFeed = new Group(container, 0);
        this.grpQuoteFeed.setText(Messages.LabelQuoteFeed);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 10);
        this.grpQuoteFeed.setLayoutData((Object)formData);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(5, 15, 5, 5).applyTo((Composite)this.grpQuoteFeed);
        Label lblProvider = new Label((Composite)this.grpQuoteFeed, 0);
        lblProvider.setText(Messages.LabelQuoteFeedProvider);
        this.comboProvider = SWTHelper.createComboViewer((Composite)this.grpQuoteFeed);
        this.comboProvider.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboProvider.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((QuoteFeed)element).getName();
            }
        });
        this.comboProvider.setInput(this.getAvailableFeeds());
        GridDataFactory.fillDefaults().hint(300, -1).applyTo(this.comboProvider.getControl());
        Link link = new Link((Composite)this.grpQuoteFeed, 4);
        link.setText("<a>" + Messages.IntroLabelHelp + "</a>");
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
                String url = "https://help.portfolio-performance.info/kursdaten_laden/";
                if (feed != null && feed.getHelpURL().isPresent()) {
                    url = (String)feed.getHelpURL().get();
                }
                if (!Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage())) {
                    url = MessageFormat.format(Messages.HelpURL, URLEncoder.encode(url, StandardCharsets.UTF_8.name()));
                }
                DesktopAPI.browse(url);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }));
        this.labelDetailData = new Label((Composite)this.grpQuoteFeed, 0);
        GridDataFactory.fillDefaults().indent(0, 5).applyTo((Control)this.labelDetailData);
        this.createDetailDataWidgets(null);
    }

    private void createDetailDataWidgets(QuoteFeed feed) {
        ControlDecoration deco;
        boolean needsJsonPath;
        boolean dropDown = feed != null && feed.getId() != null && (feed.getId().startsWith(YAHOO) || feed.getId().equals("EUROSTATHICP") || feed.getId().equals("PORTFOLIO-REPORT"));
        boolean feedURL = feed != null && feed.getId() != null && (feed.getId().equals("GENERIC_HTML_TABLE") || feed.getId().equals("CREDITSUISSE_HTML_TABLE") || feed.getId().equals("GENERIC-JSON"));
        boolean needsTicker = feed != null && feed.getId() != null && (feed.getId().equals("ALPHAVANTAGE") || feed.getId().equals("FINNHUB-CANDLE"));
        boolean needsQuandlCode = feed != null && feed.getId() != null && feed.getId().equals("QUANDL-DATASETS");
        boolean bl = needsJsonPath = feed != null && feed.getId() != null && feed.getId().equals("GENERIC-JSON");
        if (this.textFeedURL != null) {
            this.textFeedURL.dispose();
            this.textFeedURL = null;
        }
        if (this.comboExchange != null) {
            this.comboExchange.getControl().dispose();
            this.comboExchange = null;
        }
        if (this.textTicker != null) {
            this.textTicker.dispose();
            this.textTicker = null;
            this.model.removePropertyChangeListener("tickerSymbol", this.tickerSymbolPropertyChangeListener);
        }
        if (this.textQuandlCode != null) {
            this.textQuandlCode.dispose();
            this.textQuandlCode = null;
        }
        if (this.labelQuandlCloseColumnName != null) {
            this.labelQuandlCloseColumnName.dispose();
            this.labelQuandlCloseColumnName = null;
        }
        if (this.textQuandlCloseColumnName != null) {
            this.textQuandlCloseColumnName.dispose();
            this.textQuandlCloseColumnName = null;
        }
        this.labelJsonPathDate = this.disposeIf(this.labelJsonPathDate);
        this.textJsonPathDate = this.disposeIf(this.textJsonPathDate);
        this.labelJsonPathClose = this.disposeIf(this.labelJsonPathClose);
        this.textJsonPathClose = this.disposeIf(this.textJsonPathClose);
        if (dropDown) {
            this.labelDetailData.setText(Messages.LabelExchange);
            this.comboExchange = new ComboViewer((Composite)this.grpQuoteFeed, 8);
            this.comboExchange.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.comboExchange.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Exchange exchange = (Exchange)element;
                    return MessageFormat.format("{0} ({1})", exchange.getId(), exchange.getName());
                }
            });
            GridDataFactory.fillDefaults().span(2, 1).hint(300, -1).applyTo(this.comboExchange.getControl());
            this.comboExchange.addSelectionChangedListener(this::onExchangeChanged);
        }
        if (feedURL) {
            this.labelDetailData.setText(Messages.EditWizardQuoteFeedLabelFeedURL);
            this.textFeedURL = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(300, -1).applyTo((Control)this.textFeedURL);
            this.textFeedURL.addModifyListener(e -> this.onFeedURLChanged());
        }
        if (needsTicker) {
            this.labelDetailData.setText(Messages.ColumnTicker);
            this.textTicker = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.textTicker);
            ISWTObservableValue observeText = WidgetProperties.text((int)24).observe((Widget)this.textTicker);
            IObservableValue observable = BeanProperties.value((String)"tickerSymbol").observe((Object)this.model);
            this.bindings.getBindingContext().bindValue((IObservableValue)observeText, observable);
            this.model.addPropertyChangeListener("tickerSymbol", this.tickerSymbolPropertyChangeListener);
        }
        if (needsQuandlCode) {
            this.labelDetailData.setText(Messages.LabelQuandlCode);
            this.textQuandlCode = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.textQuandlCode);
            this.textQuandlCode.addModifyListener(e -> this.onQuandlCodeChanged());
            this.labelQuandlCloseColumnName = new Label((Composite)this.grpQuoteFeed, 0);
            this.labelQuandlCloseColumnName.setText(Messages.LabelQuandlColumnNameQuote);
            this.textQuandlCloseColumnName = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.textQuandlCloseColumnName);
            deco = new ControlDecoration((Control)this.textQuandlCloseColumnName, 0x1020000);
            deco.setDescriptionText(Messages.LabelQuandlColumnNameQuoteHint);
            deco.setImage(Images.INFO.image());
            deco.setMarginWidth(2);
            deco.show();
            this.textQuandlCloseColumnName.addModifyListener(e -> this.onQuandlColumnNameChanged());
        }
        if (needsJsonPath) {
            this.labelJsonPathDate = new Label((Composite)this.grpQuoteFeed, 0);
            this.labelJsonPathDate.setText(Messages.LabelJSONPathToDate);
            this.textJsonPathDate = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.textJsonPathDate);
            this.textJsonPathDate.addModifyListener(e -> this.onJsonPathDateChanged());
            deco = new ControlDecoration((Control)this.textJsonPathDate, 0x1020000);
            deco.setDescriptionText(Messages.LabelJSONPathHint);
            deco.setImage(Images.INFO.image());
            deco.setMarginWidth(2);
            deco.show();
            this.labelJsonPathClose = new Label((Composite)this.grpQuoteFeed, 0);
            this.labelJsonPathClose.setText(Messages.LabelJSONPathToClose);
            this.textJsonPathClose = new Text((Composite)this.grpQuoteFeed, 2048);
            GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)this.textJsonPathClose);
            this.textJsonPathClose.addModifyListener(e -> this.onJsonPathCloseChanged());
            deco = new ControlDecoration((Control)this.textJsonPathClose, 0x1020000);
            deco.setDescriptionText(Messages.LabelJSONPathHint);
            deco.setImage(Images.INFO.image());
            deco.setMarginWidth(2);
            deco.show();
        }
        if (!(dropDown || feedURL || needsTicker || needsQuandlCode || needsJsonPath)) {
            this.labelDetailData.setText("");
        }
        this.grpQuoteFeed.layout(true);
        this.grpQuoteFeed.getParent().layout();
    }

    private <T extends Control> T disposeIf(T control) {
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
        return null;
    }

    private void setupInitialData() {
        String code;
        this.tickerSymbol = this.model.getTickerSymbol();
        new LoadExchangesJob().schedule();
        QuoteFeed feed = this.getQuoteFeedProvider(this.getFeed());
        if (feed != null) {
            this.comboProvider.setSelection((ISelection)new StructuredSelection((Object)feed));
        } else {
            this.comboProvider.setSelection((ISelection)new StructuredSelection((Object)this.getAvailableFeeds().get(0)));
        }
        this.createDetailDataWidgets(feed);
        if (this.model.getTickerSymbol() != null && feed != null && feed.getId() != null && (feed.getId().startsWith(YAHOO) || feed.getId().equals("EUROSTATHICP"))) {
            Exchange exchange = new Exchange(this.model.getTickerSymbol(), this.model.getTickerSymbol());
            ArrayList<Exchange> input = new ArrayList<Exchange>();
            input.add(exchange);
            this.comboExchange.setInput(input);
            this.comboExchange.setSelection((ISelection)new StructuredSelection((Object)exchange));
        }
        if (feed != null && feed.getId() != null && feed.getId().equals("PORTFOLIO-REPORT") && (code = this.model.getFeedProperty("PORTFOLIO-REPORT-MARKET")) != null) {
            Exchange exchange = new Exchange(code, code);
            this.comboExchange.setInput(Arrays.asList(exchange));
            this.comboExchange.setSelection((ISelection)new StructuredSelection((Object)exchange));
        }
        if (this.textFeedURL != null && this.getFeedURL() != null) {
            this.textFeedURL.setText(this.getFeedURL());
        }
        if (this.textQuandlCode != null) {
            String columnName;
            code = this.model.getFeedProperty("QUANDLCODE");
            if (code != null) {
                this.textQuandlCode.setText(code);
            }
            if ((columnName = this.model.getFeedProperty("QUANDLCLOSE")) != null) {
                this.textQuandlCloseColumnName.setText(columnName);
            }
        }
        if (this.textJsonPathDate != null) {
            String closePath;
            String datePath = this.model.getFeedProperty(this.getJSONDatePropertyName());
            if (datePath != null) {
                this.textJsonPathDate.setText(datePath);
            }
            if ((closePath = this.model.getFeedProperty(this.getJSONClosePropertyName())) != null) {
                this.textJsonPathClose.setText(closePath);
            }
        }
    }

    private void onFeedProviderChanged(SelectionChangedEvent event) {
        QuoteFeed feed;
        Exchange exchange;
        String previousExchangeId = null;
        if (this.comboExchange != null && (exchange = (Exchange)((IStructuredSelection)this.comboExchange.getSelection()).getFirstElement()) != null) {
            previousExchangeId = exchange.getId();
        }
        if (previousExchangeId == null && this.model.getTickerSymbol() != null) {
            previousExchangeId = this.model.getTickerSymbol();
        }
        if ((feed = (QuoteFeed)((IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
            this.setFeed(feed.getId());
        }
        this.createDetailDataWidgets(feed);
        this.clearSampleQuotes();
        if (this.comboExchange != null) {
            List<Exchange> exchanges = this.cacheExchanges.get(feed);
            this.comboExchange.setInput(exchanges);
            boolean exchangeSelected = false;
            if (exchanges != null && previousExchangeId != null) {
                for (Exchange e : exchanges) {
                    if (!e.getId().equals(previousExchangeId)) continue;
                    this.comboExchange.setSelection((ISelection)new StructuredSelection((Object)e));
                    exchangeSelected = true;
                    break;
                }
            }
            if (!exchangeSelected && exchanges != null && exchanges.size() == 1) {
                this.comboExchange.setSelection((ISelection)new StructuredSelection((Object)exchanges.get(0)));
                exchangeSelected = true;
            }
            if (!exchangeSelected) {
                this.comboExchange.setSelection(null);
            }
            this.setStatus(exchangeSelected ? null : MessageFormat.format(Messages.MsgErrorExchangeMissing, this.getTitle()));
        }
        if (this.textFeedURL != null) {
            boolean hasURL;
            boolean bl = hasURL = this.getFeedURL() != null && this.getFeedURL().length() > 0;
            if (hasURL) {
                this.textFeedURL.setText(this.getFeedURL());
            }
            this.setStatus(hasURL ? null : MessageFormat.format(Messages.EditWizardQuoteFeedMsgErrorMissingURL, this.getTitle()));
        }
        if (this.textQuandlCode != null) {
            String columnName;
            String code = this.model.getFeedProperty("QUANDLCODE");
            if (code != null) {
                this.textQuandlCode.setText(code);
            }
            if ((columnName = this.model.getFeedProperty("QUANDLCLOSE")) != null) {
                this.textQuandlCloseColumnName.setText(columnName);
            }
        }
        if (this.textJsonPathDate != null) {
            String closePath;
            String datePath = this.model.getFeedProperty(this.getJSONDatePropertyName());
            if (datePath != null) {
                this.textJsonPathDate.setText(datePath);
            }
            if ((closePath = this.model.getFeedProperty(this.getJSONClosePropertyName())) != null) {
                this.textJsonPathClose.setText(closePath);
            }
        }
        if (this.comboExchange == null && this.textFeedURL == null && this.textQuandlCode == null && this.textJsonPathDate == null) {
            if (feed != null) {
                this.showSampleQuotes(feed, null);
            } else {
                this.clearSampleQuotes();
            }
            this.setStatus(null);
        }
    }

    private void onExchangeChanged(SelectionChangedEvent event) {
        Exchange exchange = (Exchange)((IStructuredSelection)event.getSelection()).getFirstElement();
        this.setStatus(null);
        if (exchange == null) {
            this.clearSampleQuotes();
        } else {
            QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
            this.showSampleQuotes(feed, exchange);
        }
    }

    private void onFeedURLChanged() {
        boolean hasURL;
        this.setFeedURL(this.textFeedURL.getText());
        boolean bl = hasURL = this.getFeedURL() != null && this.getFeedURL().length() > 0;
        if (!hasURL) {
            this.clearSampleQuotes();
            this.setStatus(MessageFormat.format(Messages.EditWizardQuoteFeedMsgErrorMissingURL, this.getTitle()));
        } else {
            QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
            this.showSampleQuotes(feed, null);
            this.setStatus(null);
        }
    }

    private void onTickerSymbolChanged() {
        boolean hasTicker;
        boolean bl = hasTicker = this.model.getTickerSymbol() != null && !this.model.getTickerSymbol().isEmpty();
        if (!hasTicker) {
            this.clearSampleQuotes();
            this.setStatus(MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnTicker));
        } else {
            QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
            this.showSampleQuotes(feed, null);
            this.setStatus(null);
        }
    }

    private void onQuandlCodeChanged() {
        boolean hasCode;
        String quandlCode = this.textQuandlCode.getText();
        boolean bl = hasCode = quandlCode != null && Pattern.matches("^.+/.+$", quandlCode);
        if (!hasCode) {
            this.clearSampleQuotes();
            this.setStatus(Messages.MsgErrorMissingQuandlCode);
        } else {
            this.model.setFeedProperty("QUANDLCODE", quandlCode);
            QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
            this.showSampleQuotes(feed, null);
            this.setStatus(null);
        }
    }

    private void onQuandlColumnNameChanged() {
        String closeColumnName = this.textQuandlCloseColumnName.getText();
        this.model.setFeedProperty("QUANDLCLOSE", closeColumnName.isEmpty() ? null : closeColumnName);
        QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
        this.showSampleQuotes(feed, null);
        this.setStatus(null);
    }

    private void onJsonPathDateChanged() {
        String datePath = this.textJsonPathDate.getText();
        this.model.setFeedProperty(this.getJSONDatePropertyName(), datePath.isEmpty() ? null : datePath);
        QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
        this.showSampleQuotes(feed, null);
        this.setStatus(null);
    }

    private void onJsonPathCloseChanged() {
        String closePath = this.textJsonPathClose.getText();
        this.model.setFeedProperty(this.getJSONClosePropertyName(), closePath.isEmpty() ? null : closePath);
        QuoteFeed feed = (QuoteFeed)((IStructuredSelection)this.comboProvider.getSelection()).getFirstElement();
        this.showSampleQuotes(feed, null);
        this.setStatus(null);
    }

    private class LoadExchangesJob
    extends Job {
        public LoadExchangesJob() {
            super(Messages.JobMsgLoadingExchanges);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            List<QuoteFeed> provider = AbstractQuoteProviderPage.this.getAvailableFeeds();
            monitor.beginTask(Messages.JobMsgLoadingExchanges, provider.size());
            for (QuoteFeed feed : provider) {
                Security s = AbstractQuoteProviderPage.this.buildTemporarySecurity();
                ArrayList<Exception> errors = new ArrayList<Exception>();
                AbstractQuoteProviderPage.this.cacheExchanges.put(feed, feed.getExchanges(s, errors));
                PortfolioPlugin.log(errors);
                monitor.worked(1);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    QuoteFeed feed = (QuoteFeed)((IStructuredSelection)((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboProvider.getSelection()).getFirstElement();
                    if (feed != null && feed.getId() != null) {
                        List<Exchange> exchanges = ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.cacheExchanges.get(feed);
                        if (((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange != null) {
                            ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange.setSelection((ISelection)StructuredSelection.EMPTY);
                            if (exchanges != null) {
                                ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange.setInput(exchanges);
                                String code = feed.getId().equals("PORTFOLIO-REPORT") ? ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.model.getFeedProperty("PORTFOLIO-REPORT-MARKET") : ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.model.getTickerSymbol();
                                exchanges.stream().filter(e -> e.getId().equals(code)).findAny().ifPresent(e -> ((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange.setSelection((ISelection)new StructuredSelection(e)));
                            }
                            if (((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange.getSelection().isEmpty()) {
                                AbstractQuoteProviderPage.this.clearSampleQuotes();
                            } else {
                                AbstractQuoteProviderPage.this.showSampleQuotes(feed, (Exchange)((StructuredSelection)((LoadExchangesJob)LoadExchangesJob.this).AbstractQuoteProviderPage.this.comboExchange.getSelection()).getFirstElement());
                            }
                        } else if (exchanges == null || exchanges.isEmpty()) {
                            AbstractQuoteProviderPage.this.showSampleQuotes(feed, null);
                        }
                    }
                }
            });
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

