/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.events;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.DatePicker;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.SimpleDateTimeDateSelectionProperty;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.events.CustomEventModel;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddCustomEventPage
extends AbstractWizardPage {
    private CustomEventModel model;
    private BindingHelper bindings;

    public AddCustomEventPage(CustomEventModel model) {
        super("add-custom-event");
        this.setTitle(Messages.EventWizardTitle);
        this.setDescription(Messages.EventWizardDescription);
        this.model = model;
        this.bindings = new BindingHelper(model){

            @Override
            public void onValidationStatusChanged(IStatus status) {
                boolean isOK = status.getSeverity() == 0;
                AddCustomEventPage.this.setErrorMessage(isOK ? null : status.getMessage());
                AddCustomEventPage.this.setPageComplete(isOK);
            }
        };
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Label labelSecurity = new Label(container, 0);
        labelSecurity.setLayoutData((Object)new FormData());
        labelSecurity.setText(Messages.ColumnSecurity);
        List securities = this.model.getClient().getActiveSecurities();
        if (this.model.getSecurity() != null && !securities.contains(this.model.getSecurity())) {
            securities.add(0, this.model.getSecurity());
        }
        ComboViewer comboSecurity = new ComboViewer(container, 8);
        Combo combo = comboSecurity.getCombo();
        combo.setLayoutData((Object)new FormData());
        comboSecurity.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboSecurity.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getName();
            }
        });
        comboSecurity.setInput((Object)securities);
        Label labelDate = new Label(container, 0);
        labelDate.setLayoutData((Object)new FormData());
        labelDate.setText(Messages.ColumnDate);
        DatePicker boxDate = new DatePicker(container);
        Label labelMessage = new Label(container, 0);
        labelMessage.setLayoutData((Object)new FormData());
        labelMessage.setText(Messages.EventWizardLabelMessage);
        Text text = new Text(container, 18436);
        FormData fd_text = new FormData();
        fd_text.right = new FormAttachment(0, 480);
        text.setLayoutData((Object)fd_text);
        text.setText("custom message");
        int labelWidth = SWTHelper.widest(new Control[]{labelSecurity, labelDate});
        FormDataFactory.startingWith(comboSecurity.getControl(), labelSecurity).thenBelow(boxDate.getControl()).label(labelDate).thenBelow((Control)text).label(labelMessage);
        FormDataFactory.startingWith((Control)labelSecurity).width(labelWidth);
        DataBindingContext context = this.bindings.getBindingContext();
        IViewerObservableValue targetObservable = ViewerProperties.singleSelection().observe((Viewer)comboSecurity);
        IObservableValue securityObservable = BeanProperties.value((String)"security").observe((Object)this.model);
        context.bindValue((IObservableValue)targetObservable, securityObservable, null, null);
        ISWTObservableValue targetExDate = new SimpleDateTimeDateSelectionProperty().observe((Widget)boxDate.getControl());
        IObservableValue modelExDate = BeanProperties.value((String)"date", LocalDate.class).observe((Object)this.model);
        context.bindValue((IObservableValue)targetExDate, modelExDate, new UpdateValueStrategy().setAfterConvertValidator(value -> value != null ? ValidationStatus.ok() : ValidationStatus.error((String)MessageFormat.format(Messages.MsgDialogInputRequired, Messages.ColumnExDate))), null);
        ISWTObservableValue messageTargetObservable = WidgetProperties.text((int)24).observe((Widget)text);
        IObservableValue messageModelObservable = BeanProperties.value((String)"message").observe((Object)this.model);
        context.bindValue((IObservableValue)messageTargetObservable, messageModelObservable);
    }
}

