/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import name.abuchen.portfolio.datatransfer.csv.AktienfreundeNetExporter;
import name.abuchen.portfolio.datatransfer.csv.CSVExporter;
import name.abuchen.portfolio.datatransfer.csv.VINISExporter;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ExportSelectionPage;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportWizard
extends Wizard {
    private final Client client;
    private final ExchangeRateProviderFactory factory;
    private ExportSelectionPage exportPage;

    public ExportWizard(Client client, ExchangeRateProviderFactory factory) {
        this.client = client;
        this.factory = factory;
    }

    public Image getDefaultPageImage() {
        return Images.BANNER.image();
    }

    public void addPages() {
        this.exportPage = new ExportSelectionPage(this.client);
        this.addPage((IWizardPage)this.exportPage);
        AbstractWizardPage.attachPageListenerTo(this.getContainer());
    }

    public boolean performFinish() {
        block18: {
            Object exportItem = this.exportPage.getExportItem();
            Class<?> exportClass = this.exportPage.getExportClass();
            File file = this.getFile(exportItem);
            if (file == null) {
                return false;
            }
            try {
                if (exportItem == AccountTransaction.class) {
                    new CSVExporter().exportAccountTransactions(file, this.client.getAccounts());
                    break block18;
                }
                if (exportClass == AccountTransaction.class) {
                    new CSVExporter().exportAccountTransactions(file, (Account)exportItem);
                    break block18;
                }
                if (exportItem == PortfolioTransaction.class) {
                    new CSVExporter().exportPortfolioTransactions(file, this.client.getPortfolios());
                    break block18;
                }
                if (exportClass == PortfolioTransaction.class) {
                    new CSVExporter().exportPortfolioTransactions(file, (Portfolio)exportItem);
                    break block18;
                }
                if (exportItem == Security.class) {
                    new CSVExporter().exportSecurityMasterData(new File(file, String.valueOf(Messages.ExportWizardSecurityMasterData) + ".csv"), this.client.getSecurities());
                    break block18;
                }
                if (exportClass == Security.class) {
                    if (Messages.ExportWizardSecurityMasterData.equals(exportItem)) {
                        new CSVExporter().exportSecurityMasterData(file, this.client.getSecurities());
                    } else if (Messages.ExportWizardMergedSecurityPrices.equals(exportItem)) {
                        new CSVExporter().exportMergedSecurityPrices(file, this.client.getSecurities());
                    } else if (Messages.ExportWizardAllTransactionsAktienfreundeNet.equals(exportItem)) {
                        new AktienfreundeNetExporter().exportAllTransactions(file, this.client);
                    } else if (Messages.ExportWizardVINISApp.equals(exportItem)) {
                        new VINISExporter().exportAllValues(file, this.client, this.factory);
                    }
                    break block18;
                }
                if (exportItem == SecurityPrice.class) {
                    new CSVExporter().exportSecurityPrices(file, this.client.getSecurities());
                    break block18;
                }
                if (exportClass == SecurityPrice.class) {
                    new CSVExporter().exportSecurityPrices(file, (Security)exportItem);
                    break block18;
                }
                throw new UnsupportedOperationException(MessageFormat.format(Messages.ExportWizardUnsupportedExport, exportClass, exportItem));
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportWizardErrorExporting, (String)e.getMessage());
            }
        }
        return true;
    }

    private File getFile(Object exportItem) {
        File file = null;
        if (exportItem instanceof Class) {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setMessage(Messages.ExportWizardSelectDirectory);
            String dir = directoryDialog.open();
            if (dir != null) {
                file = new File(dir);
            }
        } else {
            String fileName;
            String name = null;
            if (exportItem instanceof Account) {
                name = ((Account)exportItem).getName();
            } else if (exportItem instanceof Portfolio) {
                name = ((Portfolio)exportItem).getName();
            } else if (exportItem instanceof Security) {
                name = ((Security)exportItem).getIsin();
            } else if (exportItem instanceof String) {
                name = (String)exportItem;
            }
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setOverwrite(true);
            if (name != null) {
                dialog.setFileName(TextUtil.sanitizeFilename((String)(String.valueOf(name) + ".csv")));
            }
            if ((fileName = dialog.open()) != null) {
                file = new File(fileName);
            }
        }
        return file;
    }
}

