/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.File;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ErroneousImportFilesPage
extends AbstractWizardPage {
    private Map<File, List<Exception>> errors;

    public ErroneousImportFilesPage(Map<File, List<Exception>> errors) {
        super("errors");
        this.errors = errors;
        this.setTitle(Messages.LabelError);
        this.setDescription(Messages.PDFImportWizardErroneousFiles);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        TreeColumnLayout layout = new TreeColumnLayout();
        container.setLayout((Layout)layout);
        TreeViewer treeViewer = new TreeViewer(container, 67584);
        treeViewer.setContentProvider((IContentProvider)new ErrorContentProvider());
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        this.addColumns(treeViewer, layout);
        treeViewer.setInput(this.errors);
    }

    private void addColumns(TreeViewer viewer, TreeColumnLayout layout) {
        TreeViewerColumn column = new TreeViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnErrorMessages);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return ((File)element).getName();
                }
                if (element instanceof Exception) {
                    Exception e = (Exception)element;
                    String text = e.getMessage();
                    return text == null || text.isEmpty() ? e.getClass().getName() : text;
                }
                return String.valueOf(element);
            }

            public Image getImage(Object element) {
                if (element instanceof File) {
                    return Images.SECURITY_RETIRED.image();
                }
                return Images.WARNING.image();
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
    }

    private class ErrorContentProvider
    implements ITreeContentProvider {
        private ErrorContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ErroneousImportFilesPage.this.errors.keySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof File) {
                return ErroneousImportFilesPage.this.errors.get(parentElement).toArray();
            }
            if (parentElement instanceof Throwable) {
                return new Object[]{((Exception)parentElement).getCause()};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof File || element instanceof Throwable && ((Throwable)element).getCause() != null;
        }
    }
}

