/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.util.Arrays;
import java.util.List;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.core.databinding.conversion.IConverter;

final class Delimiter {
    protected static final List<Delimiter> AVAILABLE = Arrays.asList(new Delimiter(',', Messages.CSVImportSeparatorComma), new Delimiter(';', Messages.CSVImportSeparatorSemicolon), new Delimiter('\t', Messages.CSVImportSeparatorTab));
    private final char character;
    private final String label;

    Delimiter(char character, String label) {
        this.character = character;
        this.label = label;
    }

    public char getCharacter() {
        return this.character;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public static final class CharToDelimiterConverter
    implements IConverter<Character, Delimiter> {
        public Object getToType() {
            return Delimiter.class;
        }

        public Object getFromType() {
            return Character.class;
        }

        public Delimiter convert(Character fromObject) {
            for (Delimiter delimiter : AVAILABLE) {
                if (!fromObject.equals(Character.valueOf(delimiter.getCharacter()))) continue;
                return delimiter;
            }
            return null;
        }
    }

    public static final class DelimiterToCharConverter
    implements IConverter<Delimiter, Character> {
        public Object getToType() {
            return Character.class;
        }

        public Object getFromType() {
            return Delimiter.class;
        }

        public Character convert(Delimiter fromObject) {
            return Character.valueOf(fromObject.getCharacter());
        }
    }
}

