/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NewAccountPage
extends AbstractWizardPage {
    private Client client;
    private TableViewer tViewer;

    public NewAccountPage(Client client) {
        super(NewAccountPage.class.getSimpleName());
        this.client = client;
        this.setTitle(Messages.NewFileWizardAccountTitle);
        this.setDescription(Messages.NewFileWizardAccountDescription);
    }

    @Override
    public void beforePage() {
        this.tViewer.refresh();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        Label lblAcc = new Label(container, 0);
        lblAcc.setText(Messages.ColumnAccount);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblAcc);
        final Text accountName = new Text(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)accountName);
        Button button = new Button(container, 8);
        button.setText(Messages.NewFileWizardButtonAdd);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        Composite tableContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        this.tViewer = new TableViewer(tableContainer);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String acnName = accountName.getText();
                if (acnName.length() > 0) {
                    Account currentAccount = new Account();
                    currentAccount.setName(acnName);
                    currentAccount.setCurrencyCode(NewAccountPage.this.client.getBaseCurrency());
                    NewAccountPage.this.client.addAccount(currentAccount);
                    NewAccountPage.this.tViewer.refresh();
                    accountName.setText("");
                    accountName.setFocus();
                }
            }
        });
        Table table = this.tViewer.getTable();
        table.setHeaderVisible(true);
        table.setEnabled(false);
        this.tViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tViewer.setInput((Object)this.client.getAccounts());
        TableViewerColumn aCol = new TableViewerColumn(this.tViewer, 0);
        layout.setColumnData((Widget)aCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        aCol.getColumn().setText(Messages.ColumnAccount);
        aCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Account)element).getName();
            }

            public Image getImage(Object element) {
                return Images.ACCOUNT.image();
            }
        });
        container.pack();
        this.setPageComplete(true);
    }
}

