/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import java.util.HashSet;
import java.util.Set;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.TaxonomyTemplate;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class AddTaxonomyPage
extends AbstractWizardPage {
    private Client client;
    private Set<String> taxonomiesAdded = new HashSet<String>();

    public AddTaxonomyPage(Client client) {
        super(AddTaxonomyPage.class.getSimpleName());
        this.client = client;
        this.setTitle(Messages.NewFileWizardTaxonomyTitle);
        this.setDescription(Messages.NewFileWizardTaxonomyDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        final TableViewer viewer = new TableViewer(container);
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(90));
        column.getColumn().setText(Messages.ColumnTaxonomy);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TaxonomyTemplate)element).getName();
            }
        });
        column = new TableViewerColumn(viewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                TaxonomyTemplate t = (TaxonomyTemplate)element;
                if (AddTaxonomyPage.this.taxonomiesAdded.contains(t.getId())) {
                    return Images.CHECK.image();
                }
                return null;
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TaxonomyTemplate template = (TaxonomyTemplate)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (template != null && !AddTaxonomyPage.this.taxonomiesAdded.contains(template.getId())) {
                    AddTaxonomyPage.this.taxonomiesAdded.add(template.getId());
                    AddTaxonomyPage.this.client.addTaxonomy(template.build());
                    viewer.refresh((Object)template);
                }
            }
        });
        viewer.getTable().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput((Object)TaxonomyTemplate.list());
        this.setPageComplete(true);
    }
}

