/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.trades;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.snapshot.trades.TradeCollector;
import name.abuchen.portfolio.snapshot.trades.TradeCollectorException;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.TradesTableViewer;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TradeDetailsView
extends AbstractFinanceView {
    private static final String ID_WARNING_TOOL_ITEM = "warning";
    private Input input;
    private CurrencyConverter converter;
    private TradesTableViewer table;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelTrades;
    }

    @Inject
    @Optional
    public void setTrades(@Named(value="name.abuchen.portfolio.ui.param.viewparameter") Input input) {
        this.input = input;
    }

    @PostConstruct
    protected void contruct(ExchangeRateProviderFactory factory) {
        this.converter = new CurrencyConverterImpl(factory, this.getClient().getBaseCurrency());
    }

    @Override
    public void notifyModelUpdated() {
        this.converter = this.converter.with(this.getClient().getBaseCurrency());
        if (this.input == null || !this.input.getTrades().equals(this.table.getInput())) {
            this.updateFrom(this.collectAllTrades());
        }
        if (!this.table.getTableViewer().getTable().isDisposed()) {
            this.table.getTableViewer().refresh(true);
        }
    }

    @Override
    protected void addButtons(ToolBarManager toolBarManager) {
        boolean hasPreselectedTrades;
        boolean bl = hasPreselectedTrades = this.input != null;
        if (hasPreselectedTrades) {
            DropDown dropDown = new DropDown(this.input.getInterval().toString(), Images.FILTER_ON, 0);
            dropDown.setMenuListener(manager -> {
                manager.add((IAction)new SimpleAction(this.input.getInterval().toString(), a -> {
                    this.updateFrom(this.input);
                    dropDown.setImage(Images.FILTER_ON);
                }));
                manager.add((IAction)new SimpleAction(Messages.LabelAllTrades, a -> {
                    this.updateFrom(this.collectAllTrades());
                    dropDown.setImage(Images.FILTER_OFF);
                }));
            });
            toolBarManager.add((IContributionItem)dropDown);
        }
        toolBarManager.add((IContributionItem)new DropDown(Messages.MenuExportData, Images.EXPORT, 0, manager -> manager.add((IAction)new SimpleAction(String.valueOf(Messages.LabelTrades) + " (CSV)", a -> new TableViewerCSVExporter(this.table.getTableViewer()).export(String.valueOf(Messages.LabelTrades) + ".csv")))));
        toolBarManager.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.table.getShowHideColumnHelper().menuAboutToShow(manager)));
    }

    @Override
    protected Control createBody(Composite parent) {
        this.table = new TradesTableViewer(this);
        Control control = this.table.createViewControl(parent, TradesTableViewer.ViewMode.MULTIPLE_SECURITES);
        this.updateFrom(this.input != null ? this.input : this.collectAllTrades());
        new ContextMenu(this.table.getTableViewer().getControl(), this::fillContextMenu).hook();
        return control;
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.table.getTableViewer().getStructuredSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        Trade trade = (Trade)selection.getFirstElement();
        new SecurityContextMenu(this).menuAboutToShow(manager, trade.getSecurity(), trade.getPortfolio());
    }

    private void updateFrom(Input data) {
        this.table.setInput(data.getTrades());
        ToolBarManager toolBar = this.getToolBarManager();
        if (!data.getErrors().isEmpty()) {
            if (toolBar.find(ID_WARNING_TOOL_ITEM) == null) {
                SimpleAction warning = new SimpleAction(Messages.MsgErrorTradeCollectionWithErrors, Images.ERROR_NOTICE.descriptor(), a -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)data.getErrors().stream().map(Throwable::getMessage).collect(Collectors.joining("\n\n"))));
                warning.setId(ID_WARNING_TOOL_ITEM);
                toolBar.insert(0, (IContributionItem)new ActionContributionItem((IAction)warning));
                toolBar.update(true);
            }
        } else if (toolBar.remove(ID_WARNING_TOOL_ITEM) != null) {
            toolBar.update(true);
        }
    }

    private Input collectAllTrades() {
        TradeCollector collector = new TradeCollector(this.getClient(), this.converter);
        ArrayList<Trade> trades = new ArrayList<Trade>();
        ArrayList<TradeCollectorException> errors = new ArrayList<TradeCollectorException>();
        this.getClient().getSecurities().forEach(s -> {
            try {
                trades.addAll(collector.collect(s));
            }
            catch (TradeCollectorException e) {
                errors.add(e);
            }
        });
        return new Input(null, trades, errors);
    }

    public static class Input {
        private final Interval interval;
        private final List<Trade> trades;
        private final List<TradeCollectorException> errors;

        public Input(Interval interval, List<Trade> trades, List<TradeCollectorException> errors) {
            this.interval = interval;
            this.trades = trades;
            this.errors = errors;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public List<Trade> getTrades() {
            return this.trades;
        }

        public List<TradeCollectorException> getErrors() {
            return this.errors;
        }
    }
}

