/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import de.engehausen.treemap.IColorProvider;
import de.engehausen.treemap.ILabelProvider;
import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.IRectangleRenderer;
import de.engehausen.treemap.ITreeMapLayout;
import de.engehausen.treemap.ITreeModel;
import de.engehausen.treemap.IWeightedTreeModel;
import de.engehausen.treemap.impl.SquarifiedLayout;
import de.engehausen.treemap.swt.TreeMap;
import java.util.Iterator;
import javax.inject.Inject;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import name.abuchen.portfolio.ui.views.SecurityDetailsViewer;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractChartPage;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import name.abuchen.portfolio.ui.views.taxonomy.TreeMapLegend;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

class TreeMapViewer
extends AbstractChartPage {
    private TreeMap<TaxonomyNode> treeMap;
    private TreeMapLegend legend;

    @Inject
    public TreeMapViewer(TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(model, renderer);
    }

    @Override
    public void beforePage() {
    }

    @Override
    public void afterPage() {
    }

    @Override
    public void nodeChange(TaxonomyNode node) {
        this.onConfigChanged();
    }

    @Override
    public void onConfigChanged() {
        this.treeMap.setTreeModel((IWeightedTreeModel)new Model(this.getModel()));
        this.legend.setRootItem(this.getModel().getVirtualRootNode());
    }

    @Override
    public Control createControl(Composite parent) {
        Composite sash = new Composite(parent, 0);
        sash.setLayout((Layout)new SashLayout(sash, 0x1000108));
        Composite container = new Composite(sash, 0);
        container.setBackground(Display.getDefault().getSystemColor(1));
        this.treeMap = new TreeMap(container);
        this.treeMap.setTreeMapLayout((ITreeMapLayout)new SquarifiedLayout(10));
        this.treeMap.setLabelProvider((model, rectangle) -> ((TaxonomyNode)rectangle.getNode()).getName());
        this.legend = new TreeMapLegend(container, this.treeMap, this.getModel(), this.getRenderer());
        SecurityDetailsViewer details = new SecurityDetailsViewer(sash, 0, this.getModel().getClient(), true);
        this.treeMap.addSelectionChangeListener((model, rectangle, label) -> {
            TaxonomyNode node = (TaxonomyNode)rectangle.getNode();
            details.setInput(node.getBackingSecurity());
        });
        GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeMap);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.legend);
        details.getControl().setLayoutData((Object)new SashLayoutData(SWTHelper.getPackedWidth(details.getControl())));
        this.treeMap.setRectangleRenderer((IRectangleRenderer)new ClassificationRectangleRenderer(this.getModel(), this.getRenderer()));
        this.treeMap.setTreeModel((IWeightedTreeModel)new Model(this.getModel()));
        this.legend.setRootItem(this.getModel().getChartRenderingRootNode());
        return sash;
    }

    private static class ClassificationRectangleRenderer
    implements IRectangleRenderer<TaxonomyNode, PaintEvent, Color> {
        private TaxonomyModel model;
        private TaxonomyNodeRenderer colorProvider;

        public ClassificationRectangleRenderer(TaxonomyModel model, TaxonomyNodeRenderer colorProvider) {
            this.model = model;
            this.colorProvider = colorProvider;
        }

        public void render(PaintEvent event, ITreeModel<IRectangle<TaxonomyNode>> model, IRectangle<TaxonomyNode> rectangle, IColorProvider<TaxonomyNode, Color> colorProvider, ILabelProvider<TaxonomyNode> labelProvider) {
            TaxonomyNode item = (TaxonomyNode)rectangle.getNode();
            if (item.getClassification() != null) {
                return;
            }
            Color oldForeground = event.gc.getForeground();
            Color oldBackground = event.gc.getBackground();
            Rectangle r = new Rectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            this.colorProvider.drawRectangle((TaxonomyNode)((IRectangle)model.getRoot()).getNode(), item, event.gc, r);
            String label = item.getName();
            double total = this.model.getChartRenderingRootNode().getActual().getAmount();
            String info = String.format("%s (%s%%)", Values.Money.format(item.getActual()), Values.Percent.format((Object)((double)item.getActual().getAmount() / total)));
            event.gc.setForeground(Colors.getTextColor(event.gc.getBackground()));
            Point labelExtend = event.gc.textExtent(label);
            Point infoExtend = event.gc.textExtent(info);
            int width = Math.max(labelExtend.x, infoExtend.x);
            if (width <= rectangle.getWidth() || rectangle.getWidth() > rectangle.getHeight()) {
                event.gc.drawText(label, r.x + 2, r.y + 2, true);
                event.gc.drawText(info, r.x + 2, r.y + 2 + labelExtend.y, true);
            } else {
                Transform transform = new Transform((Device)event.display);
                try {
                    transform.translate((float)r.x, (float)r.y);
                    transform.rotate(-90.0f);
                    event.gc.setTransform(transform);
                    event.gc.drawString(label, -labelExtend.x - 2, 2, true);
                    event.gc.drawString(info, -infoExtend.x - 2, 2 + labelExtend.y, true);
                }
                finally {
                    transform.dispose();
                }
            }
            event.gc.setForeground(oldForeground);
            event.gc.setBackground(oldBackground);
        }

        public void highlight(PaintEvent event, ITreeModel<IRectangle<TaxonomyNode>> model, IRectangle<TaxonomyNode> rectangle, IColorProvider<TaxonomyNode, Color> colorProvider, ILabelProvider<TaxonomyNode> labelProvider) {
            event.gc.setForeground(Display.getCurrent().getSystemColor(1));
            event.gc.drawRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        }
    }

    private static class Model
    implements IWeightedTreeModel<TaxonomyNode> {
        private TaxonomyModel model;

        public Model(TaxonomyModel model) {
            this.model = model;
        }

        public Iterator<TaxonomyNode> getChildren(TaxonomyNode item) {
            return item.getChildren().iterator();
        }

        public TaxonomyNode getParent(TaxonomyNode item) {
            if (this.getRoot().equals(item)) {
                return null;
            }
            return item.getParent();
        }

        public TaxonomyNode getRoot() {
            return this.model.getChartRenderingRootNode();
        }

        public boolean hasChildren(TaxonomyNode item) {
            return !item.getChildren().isEmpty();
        }

        public long getWeight(TaxonomyNode item) {
            return item.getActual().getAmount();
        }
    }
}

