/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import de.engehausen.treemap.IRectangle;
import de.engehausen.treemap.ITreeModel;
import de.engehausen.treemap.swt.TreeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

class TreeMapLegend
extends Composite {
    private TaxonomyModel model;
    private TaxonomyNodeRenderer renderer;
    private TaxonomyNode rootItem;

    public TreeMapLegend(Composite parent, TreeMap<TaxonomyNode> treeMap, TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(parent, 0);
        this.model = model;
        this.renderer = renderer;
        this.setBackground(parent.getBackground());
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.pack = true;
        layout.justify = false;
        this.setLayout((Layout)layout);
        treeMap.addSelectionChangeListener((treeModel, rectangle, label) -> this.selectionChanged((ITreeModel<IRectangle<TaxonomyNode>>)treeModel));
    }

    public void setRootItem(TaxonomyNode rootItem) {
        this.rootItem = rootItem;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        TaxonomyNode root = this.model.getChartRenderingRootNode();
        boolean hasParent = false;
        List<TaxonomyNode> path = rootItem.getPath();
        int ii = 0;
        while (ii < path.size()) {
            TaxonomyNode item = path.get(ii);
            if (hasParent || item.equals(root)) {
                hasParent = true;
                new LegendItem(this, item);
            }
            ++ii;
        }
        if (hasParent && !rootItem.getChildren().isEmpty()) {
            Label l = new Label((Composite)this, 0);
            l.setText(">>");
            l.setBackground(this.getBackground());
        }
        ArrayList<TaxonomyNode> children = new ArrayList<TaxonomyNode>(rootItem.getChildren());
        Collections.sort(children, (o1, o2) -> Long.compare(o2.getActual().getAmount(), o1.getActual().getAmount()));
        for (TaxonomyNode child : children) {
            new LegendItem(this, child);
        }
        this.pack();
        this.getParent().layout();
    }

    private void selectionChanged(ITreeModel<IRectangle<TaxonomyNode>> model) {
        TaxonomyNode newRoot = (TaxonomyNode)((IRectangle)model.getRoot()).getNode();
        if (!newRoot.equals(this.rootItem)) {
            this.setRootItem(newRoot);
        }
    }

    public class LegendItem
    extends Canvas
    implements Listener {
        private final TaxonomyNode item;

        public LegendItem(Composite parent, TaxonomyNode item) {
            super(parent, 262144);
            this.item = item;
            this.addListener(9, this);
            this.addListener(11, this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.paintControl(event);
                    break;
                }
                case 11: {
                    this.redraw();
                    break;
                }
            }
        }

        private void paintControl(Event e) {
            Color oldForeground = e.gc.getForeground();
            Color oldBackground = e.gc.getBackground();
            Point size = this.getSize();
            Rectangle r = new Rectangle(0, 0, size.x, size.y);
            TreeMapLegend.this.renderer.drawRectangle(TreeMapLegend.this.rootItem, this.item, e.gc, r);
            String text = this.item.getName();
            String info = this.getInfo();
            GC gc = e.gc;
            gc.setForeground(Colors.getTextColor(gc.getBackground()));
            gc.drawString(text, 2, 2, true);
            Point extent = gc.stringExtent(text);
            gc.drawString(info, 2, extent.y + 1, true);
            e.gc.setForeground(oldForeground);
            e.gc.setBackground(oldBackground);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            String text = this.item.getName();
            String info = this.getInfo();
            GC gc = new GC((Drawable)this);
            Point extentText = gc.stringExtent(text);
            Point extentInfo = gc.stringExtent(info);
            gc.dispose();
            return new Point(Math.max(extentText.x, extentInfo.x) + 4, extentText.y + extentInfo.y + 4);
        }

        private String getInfo() {
            return String.format("%s (%s%%)", Values.Money.format(this.item.getActual()), Values.Percent.format((Object)((double)this.item.getActual().getAmount() / (double)TreeMapLegend.this.model.getVirtualRootNode().getActual().getAmount())));
        }
    }
}

