/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;

public abstract class TaxonomyNode
implements Adaptable {
    private TaxonomyNode parent;
    private List<TaxonomyNode> children = new ArrayList<TaxonomyNode>();
    private Money actual;
    private Money target;

    TaxonomyNode(TaxonomyNode parent) {
        this.parent = parent;
    }

    public TaxonomyNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TaxonomyNode getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public List<TaxonomyNode> getChildren() {
        return this.children;
    }

    public TaxonomyNode getChildByInvestmentVehicle(InvestmentVehicle investmentVehicle) {
        for (TaxonomyNode child : this.children) {
            if (!child.isAssignment() || !investmentVehicle.equals(child.getAssignment().getInvestmentVehicle())) continue;
            return child;
        }
        return null;
    }

    public Security getBackingSecurity() {
        return null;
    }

    public boolean isClassification() {
        return this.getClassification() != null;
    }

    public abstract Classification getClassification();

    public boolean isAssignment() {
        return this.getAssignment() != null;
    }

    public abstract Classification.Assignment getAssignment();

    public boolean isUnassignedCategory() {
        return false;
    }

    public Money getActual() {
        return this.actual;
    }

    public void setActual(Money actual) {
        this.actual = actual;
    }

    public Money getTarget() {
        return this.target;
    }

    public void setTarget(Money target) {
        this.target = target;
    }

    public abstract String getId();

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getWeight();

    public abstract void setWeight(int var1);

    public abstract int getRank();

    public abstract void setRank(int var1);

    public abstract String getColor();

    public abstract Object setData(String var1, Object var2);

    public abstract Object getData(String var1);

    public List<TaxonomyNode> getPath() {
        LinkedList<TaxonomyNode> path = new LinkedList<TaxonomyNode>();
        TaxonomyNode item = this;
        while (item != null) {
            path.addFirst(item);
            item = item.getParent();
        }
        return path;
    }

    public <T> T adapt(Class<T> type) {
        if (type == Security.class) {
            return type.cast(this.getBackingSecurity());
        }
        if (type == Attributable.class) {
            return type.cast(this.getBackingSecurity());
        }
        return null;
    }

    TaxonomyNode addChild(Classification newClassification) {
        Classification classification = this.getClassification();
        if (classification == null) {
            return null;
        }
        newClassification.setWeight(Classification.ONE_HUNDRED_PERCENT - classification.getChildrenWeight());
        newClassification.setParent(classification);
        classification.addChild(newClassification);
        ClassificationNode newChild = new ClassificationNode(this, newClassification);
        newChild.setActual(Money.of((String)this.actual.getCurrencyCode(), (long)0L));
        newChild.setTarget(Money.of((String)this.target.getCurrencyCode(), (long)0L));
        int insertAt = this.isRoot() ? this.children.size() - 1 : this.children.size();
        this.children.add(insertAt, newChild);
        int ii = 0;
        while (ii < this.children.size()) {
            this.children.get(ii).setRank(ii);
            ++ii;
        }
        return newChild;
    }

    TaxonomyNode addChild(Classification.Assignment newAssignment) {
        Classification classification = this.getClassification();
        if (classification == null) {
            return null;
        }
        classification.addAssignment(newAssignment);
        AssignmentNode newChild = new AssignmentNode(this, newAssignment);
        ((TaxonomyNode)newChild).setRank(this.getTopRank() + 1);
        this.children.add(newChild);
        return newChild;
    }

    void removeChild(TaxonomyNode node) {
        Classification classification = this.getClassification();
        if (classification == null) {
            throw new UnsupportedOperationException();
        }
        if (node.isClassification()) {
            classification.getChildren().remove(node.getClassification());
        } else {
            classification.getAssignments().remove(node.getAssignment());
        }
        this.children.remove(node);
    }

    void moveTo(TaxonomyNode target) {
        this.moveTo(-1, target);
    }

    private void moveTo(int index, TaxonomyNode target) {
        InvestmentVehicle investmentVehicle;
        TaxonomyNode sibling;
        Classification classification = target.getClassification();
        if (classification == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isAssignment() && (sibling = target.getChildByInvestmentVehicle(investmentVehicle = this.getAssignment().getInvestmentVehicle())) != null) {
            sibling.absorb(this);
            return;
        }
        this.getParent().removeChild(this);
        this.parent = target;
        if (this.isClassification()) {
            this.getClassification().setParent(classification);
            classification.getChildren().add(this.getClassification());
        } else {
            classification.getAssignments().add(this.getAssignment());
        }
        List<TaxonomyNode> siblings = target.getChildren();
        if (index == -1) {
            index = siblings.size();
        }
        int insertAt = target.isRoot() ? Math.min(index, siblings.size() - 1) : index;
        siblings.add(insertAt, this);
        int ii = 0;
        while (ii < siblings.size()) {
            siblings.get(ii).setRank(ii);
            ++ii;
        }
    }

    void insertAfter(TaxonomyNode target) {
        this.moveRelativeTo(target, 1);
    }

    void insertBefore(TaxonomyNode target) {
        this.moveRelativeTo(target, 0);
    }

    private void moveRelativeTo(TaxonomyNode target, int offset) {
        if (target.isRoot()) {
            return;
        }
        if (target.getParent() == this.getParent()) {
            List<TaxonomyNode> siblings = this.getParent().getChildren();
            siblings.remove(this);
            int targetAt = siblings.indexOf(target) + offset;
            int insertAt = target.getParent().isRoot() ? Math.min(targetAt, siblings.size() - 1) : targetAt;
            siblings.add(insertAt, this);
            int ii = 0;
            while (ii < siblings.size()) {
                siblings.get(ii).setRank(ii);
                ++ii;
            }
        } else {
            int index = target.getParent().getChildren().indexOf(target);
            this.moveTo(index + offset, target.getParent());
        }
    }

    private void absorb(TaxonomyNode node) {
        if (!node.getAssignment().getInvestmentVehicle().equals(this.getAssignment().getInvestmentVehicle())) {
            throw new UnsupportedOperationException();
        }
        node.getParent().removeChild(node);
        int weight = Math.min(this.getWeight() + node.getWeight(), Classification.ONE_HUNDRED_PERCENT);
        this.setWeight(weight);
    }

    int getTopRank() {
        if (this.children.isEmpty()) {
            return -1;
        }
        return this.children.get(this.children.size() - 1).getRank();
    }

    public void accept(TaxonomyModel.NodeVisitor visitor) {
        visitor.visit(this);
        for (TaxonomyNode child : new ArrayList<TaxonomyNode>(this.children)) {
            child.accept(visitor);
        }
    }

    static class AssignmentNode
    extends TaxonomyNode {
        private Classification.Assignment assignment;

        public AssignmentNode(TaxonomyNode parent, Classification.Assignment assignment) {
            super(parent);
            this.assignment = assignment;
        }

        @Override
        public Security getBackingSecurity() {
            if (this.assignment.getInvestmentVehicle() instanceof Security) {
                return (Security)this.assignment.getInvestmentVehicle();
            }
            return null;
        }

        @Override
        public Classification getClassification() {
            return null;
        }

        @Override
        public Classification.Assignment getAssignment() {
            return this.assignment;
        }

        @Override
        public int getWeight() {
            return this.assignment.getWeight();
        }

        @Override
        public void setWeight(int weight) {
            this.assignment.setWeight(weight);
        }

        @Override
        public int getRank() {
            return this.assignment.getRank();
        }

        @Override
        public void setRank(int rank) {
            this.assignment.setRank(rank);
        }

        @Override
        public String getName() {
            return this.assignment.getInvestmentVehicle().getName();
        }

        @Override
        public void setName(String name) {
            this.assignment.getInvestmentVehicle().setName(name);
        }

        @Override
        public String getId() {
            return this.assignment.getInvestmentVehicle().getUUID();
        }

        @Override
        public Object setData(String key, Object object) {
            return this.assignment.setData(key, object);
        }

        @Override
        public Object getData(String key) {
            return this.assignment.getData(key);
        }

        @Override
        public String getColor() {
            if (this.assignment.getInvestmentVehicle() instanceof Security) {
                return Colors.toHex(Colors.EQUITY);
            }
            return Colors.toHex(Colors.CASH);
        }

        @Override
        public <T> T adapt(Class<T> type) {
            if (type == Named.class || type == Annotated.class) {
                return type.cast(this.assignment.getInvestmentVehicle());
            }
            return super.adapt(type);
        }
    }

    static class ClassificationNode
    extends TaxonomyNode {
        private Classification classification;

        public ClassificationNode(TaxonomyNode parent, Classification classification) {
            super(parent);
            this.classification = classification;
        }

        @Override
        public Classification getClassification() {
            return this.classification;
        }

        @Override
        public Classification.Assignment getAssignment() {
            return null;
        }

        @Override
        public int getWeight() {
            return this.classification.getWeight();
        }

        @Override
        public void setWeight(int weight) {
            this.classification.setWeight(weight);
        }

        @Override
        public int getRank() {
            return this.classification.getRank();
        }

        @Override
        public void setRank(int rank) {
            this.classification.setRank(rank);
        }

        @Override
        public String getName() {
            return this.classification.getName();
        }

        @Override
        public void setName(String name) {
            this.classification.setName(name);
        }

        @Override
        public String getId() {
            return this.classification.getId();
        }

        @Override
        public String getColor() {
            return this.classification.getColor();
        }

        @Override
        public Object setData(String key, Object object) {
            return this.classification.setData(key, object);
        }

        @Override
        public Object getData(String key) {
            return this.classification.getData(key);
        }

        @Override
        public <T> T adapt(Class<T> type) {
            if (type == Named.class || type == Annotated.class) {
                return type.cast(this.classification);
            }
            return super.adapt(type);
        }

        public String toString() {
            return this.getName();
        }
    }

    static class UnassignedContainerNode
    extends ClassificationNode {
        public UnassignedContainerNode(TaxonomyNode parent, Classification classification) {
            super(parent, classification);
            super.setWeight(0);
        }

        @Override
        public boolean isUnassignedCategory() {
            return true;
        }

        @Override
        public String getColor() {
            return Colors.toHex(Colors.OTHER_CATEGORY);
        }
    }
}

