/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.taxonomy.ExpectedReturnsAttachedModel;
import name.abuchen.portfolio.ui.views.taxonomy.RecalculateTargetsAttachedModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;

public final class TaxonomyModel {
    public static final String KEY_FILTER_NON_ZERO = "-filter-non-zero";
    public static final String KEY_FILTER_NOT_RETIRED = "-filter-not-retired";
    public static final Predicate<TaxonomyNode> FILTER_NON_ZERO = node -> node.isClassification() || !node.getActual().isZero();
    public static final Predicate<TaxonomyNode> FILTER_NOT_RETIRED = node -> node.isClassification() || !node.getAssignment().getInvestmentVehicle().isRetired();
    private final Taxonomy taxonomy;
    private final Client client;
    private final ExchangeRateProviderFactory factory;
    private CurrencyConverter converter;
    private Client filteredClient;
    private ClientSnapshot snapshot;
    private TaxonomyNode virtualRootNode;
    private TaxonomyNode classificationRootNode;
    private TaxonomyNode unassignedNode;
    private Map<InvestmentVehicle, Classification.Assignment> investmentVehicle2weight = new HashMap<InvestmentVehicle, Classification.Assignment>();
    private boolean excludeUnassignedCategoryInCharts = false;
    private boolean excludeSecuritiesInPieChart = false;
    private boolean orderByTaxonomyInStackChart = false;
    private String expansionStateDefinition;
    private String expansionStateRebalancing;
    private List<Predicate<TaxonomyNode>> nodeFilters = new ArrayList<Predicate<TaxonomyNode>>();
    private List<AttachedModel> attachedModels = new ArrayList<AttachedModel>();
    private List<TaxonomyModelUpdatedListener> listeners = new ArrayList<TaxonomyModelUpdatedListener>();
    private List<DirtyListener> dirtyListener = new ArrayList<DirtyListener>();

    @Inject
    TaxonomyModel(ExchangeRateProviderFactory factory, Client client, Taxonomy taxonomy) {
        this.taxonomy = Objects.requireNonNull(taxonomy);
        this.client = Objects.requireNonNull(client);
        this.factory = Objects.requireNonNull(factory);
        this.converter = new CurrencyConverterImpl(factory, client.getBaseCurrency());
        this.filteredClient = client;
        this.snapshot = ClientSnapshot.create((Client)client, (CurrencyConverter)this.converter, (LocalDate)LocalDate.now());
        this.attachedModels.add(new RecalculateTargetsAttachedModel());
        this.attachedModels.add(new ExpectedReturnsAttachedModel());
        Classification virtualRoot = new Classification(null, "$virtualroot$", Messages.PerformanceChartLabelEntirePortfolio, taxonomy.getRoot().getColor());
        this.virtualRootNode = new TaxonomyNode.ClassificationNode(null, virtualRoot);
        Classification classificationRoot = taxonomy.getRoot();
        this.classificationRootNode = new TaxonomyNode.ClassificationNode(this.virtualRootNode, classificationRoot);
        this.virtualRootNode.getChildren().add(this.classificationRootNode);
        LinkedList<TaxonomyNode> stack = new LinkedList<TaxonomyNode>();
        stack.add(this.classificationRootNode);
        while (!stack.isEmpty()) {
            TaxonomyNode m2 = (TaxonomyNode)stack.pop();
            Classification classification = m2.getClassification();
            for (Classification c : classification.getChildren()) {
                TaxonomyNode.ClassificationNode cm = new TaxonomyNode.ClassificationNode(m2, c);
                stack.push(cm);
                m2.getChildren().add(cm);
            }
            for (Classification.Assignment assignment : classification.getAssignments()) {
                m2.getChildren().add(new TaxonomyNode.AssignmentNode(m2, assignment));
            }
            Collections.sort(m2.getChildren(), (o1, o2) -> Integer.compare(o1.getRank(), o2.getRank()));
        }
        this.unassignedNode = new TaxonomyNode.UnassignedContainerNode(this.virtualRootNode, new Classification(virtualRoot, "$unassigned$", Messages.LabelWithoutClassification));
        this.virtualRootNode.getChildren().add(this.unassignedNode);
        this.addUnassigned(client);
        this.visitActuals(this.snapshot, this.virtualRootNode);
        this.attachedModels.forEach(m -> m.setup(this));
        this.runRecalculations();
    }

    private void addUnassigned(Client client) {
        Classification.Assignment assignment;
        for (Security security : client.getSecurities()) {
            assignment = new Classification.Assignment((InvestmentVehicle)security);
            assignment.setWeight(0);
            this.investmentVehicle2weight.put((InvestmentVehicle)security, assignment);
        }
        for (Account account : client.getAccounts()) {
            assignment = new Classification.Assignment((InvestmentVehicle)account);
            assignment.setWeight(0);
            this.investmentVehicle2weight.put((InvestmentVehicle)account, assignment);
        }
        this.visitAll(node -> {
            if (!(node instanceof TaxonomyNode.AssignmentNode)) {
                return;
            }
            Classification.Assignment assignment = node.getAssignment();
            Classification.Assignment count = this.investmentVehicle2weight.get(assignment.getInvestmentVehicle());
            count.setWeight(count.getWeight() + assignment.getWeight());
        });
        ArrayList<Classification.Assignment> unassigned = new ArrayList<Classification.Assignment>();
        for (Classification.Assignment assignment2 : this.investmentVehicle2weight.values()) {
            if (assignment2.getWeight() >= Classification.ONE_HUNDRED_PERCENT) continue;
            Classification.Assignment a = new Classification.Assignment(assignment2.getInvestmentVehicle());
            a.setWeight(Classification.ONE_HUNDRED_PERCENT - assignment2.getWeight());
            unassigned.add(a);
            assignment2.setWeight(Classification.ONE_HUNDRED_PERCENT);
        }
        Collections.sort(unassigned, (o1, o2) -> o1.getInvestmentVehicle().toString().compareToIgnoreCase(o2.getInvestmentVehicle().toString()));
        for (Classification.Assignment assignment2 : unassigned) {
            this.unassignedNode.addChild(assignment2);
        }
    }

    private void visitActuals(ClientSnapshot snapshot, TaxonomyNode node) {
        MutableMoney actual = MutableMoney.of((String)snapshot.getCurrencyCode());
        for (TaxonomyNode child : node.getChildren()) {
            this.visitActuals(snapshot, child);
            actual.add(child.getActual());
        }
        if (node.isAssignment()) {
            Classification.Assignment assignment = node.getAssignment();
            AssetPosition p = (AssetPosition)snapshot.getPositionsByVehicle().get(assignment.getInvestmentVehicle());
            if (p != null) {
                Money valuation = p.getValuation();
                actual.add(Money.of((String)valuation.getCurrencyCode(), (long)Math.round((double)(valuation.getAmount() * (long)assignment.getWeight()) / (double)Classification.ONE_HUNDRED_PERCENT)));
            }
        }
        node.setActual(actual.toMoney());
    }

    private void runRecalculations() {
        this.attachedModels.forEach(m -> m.recalculate(this));
    }

    public boolean isUnassignedCategoryInChartsExcluded() {
        return this.excludeUnassignedCategoryInCharts;
    }

    public void setExcludeUnassignedCategoryInCharts(boolean excludeUnassignedCategoryInCharts) {
        this.excludeUnassignedCategoryInCharts = excludeUnassignedCategoryInCharts;
    }

    public boolean isSecuritiesInPieChartExcluded() {
        return this.excludeSecuritiesInPieChart;
    }

    public void setExcludeSecuritiesInPieChart(boolean excludeSecuritiesInPieChart) {
        this.excludeSecuritiesInPieChart = excludeSecuritiesInPieChart;
    }

    public boolean isOrderByTaxonomyInStackChart() {
        return this.orderByTaxonomyInStackChart;
    }

    public void setOrderByTaxonomyInStackChart(boolean orderByTaxonomyInStackChart) {
        this.orderByTaxonomyInStackChart = orderByTaxonomyInStackChart;
    }

    public String getExpansionStateDefinition() {
        return this.expansionStateDefinition;
    }

    public void setExpansionStateDefinition(String expansionStateDefinition) {
        this.expansionStateDefinition = expansionStateDefinition;
    }

    public String getExpansionStateRebalancing() {
        return this.expansionStateRebalancing;
    }

    public void setExpansionStateRebalancing(String expansionStateRebalancing) {
        this.expansionStateRebalancing = expansionStateRebalancing;
    }

    public List<Predicate<TaxonomyNode>> getNodeFilters() {
        return this.nodeFilters;
    }

    public Stream<AttachedModel> getAttachedModels() {
        return this.attachedModels.stream();
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public TaxonomyNode getVirtualRootNode() {
        return this.virtualRootNode;
    }

    public TaxonomyNode getClassificationRootNode() {
        return this.classificationRootNode;
    }

    public TaxonomyNode getUnassignedNode() {
        return this.unassignedNode;
    }

    public TaxonomyNode getChartRenderingRootNode() {
        return this.isUnassignedCategoryInChartsExcluded() || this.getUnassignedNode().getActual().isZero() ? this.getClassificationRootNode() : this.getVirtualRootNode();
    }

    public Client getClient() {
        return this.client;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public String getCurrencyCode() {
        return this.converter.getTermCurrency();
    }

    public void updateClientSnapshot(Client filteredClient) {
        if (!filteredClient.getBaseCurrency().equals(this.converter.getTermCurrency())) {
            this.converter = new CurrencyConverterImpl(this.factory, filteredClient.getBaseCurrency());
        }
        this.filteredClient = filteredClient;
        this.snapshot = ClientSnapshot.create((Client)filteredClient, (CurrencyConverter)this.converter, (LocalDate)LocalDate.now());
        this.recalculate();
        this.fireTaxonomyModelChange(this.getVirtualRootNode());
    }

    public Client getFilteredClient() {
        return this.filteredClient;
    }

    public ClientSnapshot getClientSnapshot() {
        return this.snapshot;
    }

    public void recalculate() {
        this.virtualRootNode.setActual(this.snapshot.getMonetaryAssets());
        this.visitActuals(this.snapshot, this.virtualRootNode);
        this.runRecalculations();
    }

    public void visitAll(NodeVisitor visitor) {
        this.virtualRootNode.accept(visitor);
    }

    public void addListener(TaxonomyModelUpdatedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TaxonomyModelUpdatedListener listener) {
        this.listeners.remove(listener);
    }

    public void fireTaxonomyModelChange(TaxonomyNode node) {
        this.listeners.forEach(listener -> listener.nodeChange(node));
    }

    public void addDirtyListener(DirtyListener listener) {
        this.dirtyListener.add(listener);
    }

    public void markDirty() {
        this.dirtyListener.forEach(DirtyListener::onModelEdited);
    }

    public int getWeightByInvestmentVehicle(InvestmentVehicle vehicle) {
        return this.investmentVehicle2weight.get(vehicle).getWeight();
    }

    public void setWeightByInvestmentVehicle(InvestmentVehicle vehicle, int weight) {
        this.investmentVehicle2weight.get(vehicle).setWeight(weight);
    }

    public boolean hasWeightError(TaxonomyNode node) {
        if (node.isUnassignedCategory() || node.isRoot()) {
            return false;
        }
        if (node.isClassification()) {
            if (node.getParent().isRoot()) {
                return node.getWeight() != Classification.ONE_HUNDRED_PERCENT;
            }
            return node.getClassification().getParent().getChildrenWeight() != Classification.ONE_HUNDRED_PERCENT;
        }
        return this.getWeightByInvestmentVehicle(node.getAssignment().getInvestmentVehicle()) != Classification.ONE_HUNDRED_PERCENT;
    }

    public static interface AttachedModel {
        default public void setup(TaxonomyModel model) {
        }

        public void recalculate(TaxonomyModel var1);

        default public void addColumns(ShowHideColumnHelper columns) {
        }
    }

    @FunctionalInterface
    public static interface DirtyListener {
        public void onModelEdited();
    }

    @FunctionalInterface
    public static interface NodeVisitor {
        public void visit(TaxonomyNode var1);
    }

    @FunctionalInterface
    public static interface TaxonomyModelUpdatedListener {
        public void nodeChange(TaxonomyNode var1);
    }
}

