/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.util.BindingHelper;

public class RebalancingColoringRule
extends BindingHelper.Model {
    private static final String KEY_RELATIVE_THRESHOLD = "taxonomy.rebalancing.relative-threshold";
    private static final String KEY_ABSOLUTE_THRESHOLD = "taxonomy.rebalancing.absolute-threshold";
    private static final String KEY_BAR_LENGTH = "taxonomy.rebalancing.bar-length";
    private int relativeThreshold;
    private int absoluteThreshold;
    private int barLength;

    public RebalancingColoringRule(Client client) {
        super(client);
        this.relativeThreshold = client.getPropertyInt(KEY_RELATIVE_THRESHOLD);
        if (this.relativeThreshold == 0) {
            this.relativeThreshold = 25;
        }
        this.absoluteThreshold = client.getPropertyInt(KEY_ABSOLUTE_THRESHOLD);
        if (this.absoluteThreshold == 0) {
            this.absoluteThreshold = 5;
        }
        this.barLength = client.getPropertyInt(KEY_BAR_LENGTH);
        if (this.barLength == 0) {
            this.barLength = 20;
        }
    }

    public int getRelativeThreshold() {
        return this.relativeThreshold;
    }

    public void setRelativeThreshold(int relativeThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.firePropertyChange("relativeThreshold", this.relativeThreshold, this.relativeThreshold);
    }

    public int getAbsoluteThreshold() {
        return this.absoluteThreshold;
    }

    public void setAbsoluteThreshold(int absoluteThreshold) {
        this.absoluteThreshold = absoluteThreshold;
        this.firePropertyChange("absoluteThreshold", this.absoluteThreshold, this.absoluteThreshold);
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int barLength) {
        this.barLength = barLength;
        this.firePropertyChange("price", this.barLength, this.barLength);
    }

    @Override
    public void applyChanges() {
        Client client = this.getClient();
        client.setProperty(KEY_RELATIVE_THRESHOLD, String.valueOf(this.relativeThreshold));
        client.setProperty(KEY_ABSOLUTE_THRESHOLD, String.valueOf(this.absoluteThreshold));
        client.setProperty(KEY_BAR_LENGTH, String.valueOf(this.barLength));
    }
}

