/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import com.ibm.icu.text.MessageFormat;
import javax.inject.Inject;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.EmbeddedBrowser;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.taxonomy.AbstractChartPage;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNodeRenderer;
import name.abuchen.portfolio.util.ColorConversion;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.json.simple.JSONObject;

class PieChartViewer
extends AbstractChartPage {
    private EmbeddedBrowser browser;

    @Inject
    public PieChartViewer(TaxonomyModel model, TaxonomyNodeRenderer renderer) {
        super(model, renderer);
    }

    @Override
    public void configMenuAboutToShow(IMenuManager manager) {
        super.configMenuAboutToShow(manager);
        SimpleAction action = new SimpleAction(Messages.LabelIncludeSecuritiesInPieChart, a -> {
            this.getModel().setExcludeSecuritiesInPieChart(!this.getModel().isSecuritiesInPieChartExcluded());
            this.onConfigChanged();
        });
        action.setChecked(!this.getModel().isSecuritiesInPieChartExcluded());
        manager.add((IAction)action);
    }

    @Override
    public Control createControl(Composite container) {
        this.browser = this.make(EmbeddedBrowser.class);
        this.browser.setHtmlpage("/META-INF/html/flare.html");
        return this.browser.createControl(container, b -> {
            LoadDataFunction loadDataFunction = new LoadDataFunction((Browser)b, "loadData");
        });
    }

    @Override
    public void beforePage() {
    }

    @Override
    public void afterPage() {
    }

    @Override
    public void nodeChange(TaxonomyNode node) {
        this.browser.refresh();
    }

    @Override
    public void onConfigChanged() {
        this.browser.refresh();
    }

    private final class LoadDataFunction
    extends BrowserFunction {
        private LoadDataFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            try {
                TaxonomyNode root = PieChartViewer.this.getModel().getChartRenderingRootNode();
                StringBuilder buffer = new StringBuilder();
                this.printNode(buffer, root, "", root.getActual(), PieChartViewer.this.getModel().isSecuritiesInPieChartExcluded());
                return buffer.toString();
            }
            catch (Throwable e) {
                PortfolioPlugin.log(e);
                return "{}";
            }
        }

        private void printNode(StringBuilder buffer, TaxonomyNode node, String nodeColor, Money total, boolean excludeSecurities) {
            String name = JSONObject.escape((String)node.getName());
            long actual = node.isRoot() ? total.getAmount() : node.getActual().getAmount();
            long base = node.isRoot() ? total.getAmount() : node.getParent().getActual().getAmount();
            String totalPercentage = "";
            if (node.getParent() != null && !node.getParent().isRoot()) {
                totalPercentage = "; " + MessageFormat.format((String)Messages.LabelTotalValuePercent, (Object[])new Object[]{Values.Percent2.format((Object)((double)actual / (double)total.getAmount()))});
            }
            if (excludeSecurities && node.isAssignment()) {
                buffer.append("{\"name\":\"\",\"caption\":\"\",");
                buffer.append("\"value\":").append(node.getActual().getAmount());
                buffer.append(",\"color\":\"#FFFFFF\"");
            } else {
                buffer.append("{\"name\":\"").append(name);
                buffer.append("\",\"caption\":\"");
                buffer.append(name).append(" ").append(Values.Amount.format((Object)actual)).append(" (").append(Values.Percent2.format((Object)((double)actual / (double)base))).append(totalPercentage).append(")\",");
                buffer.append("\"value\":").append(node.getActual().getAmount());
                buffer.append(",\"color\":\"").append(node.isAssignment() ? ColorConversion.brighter((String)nodeColor) : node.getColor()).append("\"");
            }
            this.addChildren(buffer, node, node.getColor(), total, excludeSecurities);
            buffer.append("}");
        }

        private void addChildren(StringBuilder buffer, TaxonomyNode node, String nodeColor, Money total, boolean excludeSecurities) {
            boolean iterateChildren;
            boolean bl = iterateChildren = !excludeSecurities || node.getChildren().stream().anyMatch(n -> !n.isAssignment());
            if (!iterateChildren) {
                return;
            }
            boolean isFirst = true;
            for (TaxonomyNode child : node.getChildren()) {
                if (child.getActual().isZero()) continue;
                if (isFirst) {
                    buffer.append(",\"children\": [");
                } else {
                    buffer.append(",");
                }
                this.printNode(buffer, child, nodeColor, total, excludeSecurities);
                isFirst = false;
            }
            if (!isFirst) {
                buffer.append("]");
            }
        }
    }
}

