/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.settings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.views.AbstractTabbedView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BookmarksListTab
implements AbstractTabbedView.Tab,
ColumnEditingSupport.ModificationListener {
    private static final String DEFAULT_URL = "http://example.net/{tickerSymbol}?isin={isin}&wkn={wkn}&name={name}";
    private TableViewer bookmarks;
    @Inject
    private Client client;
    @Inject
    private IPreferenceStore preferences;

    @Override
    public String getTitle() {
        return Messages.BookmarksListView_title;
    }

    @Override
    public void addButtons(ToolBarManager manager) {
        manager.add((IContributionItem)new DropDown(Messages.BookmarksListView_NewBookmark, Images.PLUS, 0, menuListener -> {
            menuListener.add((IAction)new SimpleAction(Messages.BookmarksListView_NewBookmark, a -> {
                Bookmark wl = new Bookmark(Messages.BookmarksListView_NewBookmark, DEFAULT_URL);
                this.client.getSettings().getBookmarks().add(wl);
                this.client.touch();
                this.bookmarks.setInput((Object)this.client.getSettings().getBookmarks());
                this.bookmarks.editElement((Object)wl, 0);
            }));
            menuListener.add((IContributionItem)new Separator());
            menuListener.add((IAction)new LabelOnly(Messages.LabelTaxonomyTemplates));
            List templates = ClientSettings.getDefaultBookmarks();
            Collections.sort(templates, (r, l) -> r.getLabel().compareTo(l.getLabel()));
            templates.forEach(bm -> menuListener.add((IAction)new SimpleAction(bm.getLabel(), a -> {
                this.client.getSettings().getBookmarks().add(bm);
                this.client.touch();
                this.bookmarks.setInput((Object)this.client.getSettings().getBookmarks());
                this.bookmarks.editElement(bm, 0);
            })));
        }));
    }

    @Override
    public Composite createTab(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.bookmarks = new TableViewer(container, 65538);
        ColumnEditingSupport.prepare((ColumnViewer)this.bookmarks);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(BookmarksListTab.class.getSimpleName()) + "@bottom", this.preferences, this.bookmarks, layout);
        Column column = new Column(Messages.BookmarksListView_bookmark, 0, 150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Bookmark)element).getLabel();
            }

            public Image getImage(Object element) {
                return Images.BOOKMARK.image();
            }
        });
        new StringEditingSupport(Bookmark.class, "label").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.BookmarksListView_url, 0, 500);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Bookmark)element).getPattern();
            }
        });
        new StringEditingSupport(Bookmark.class, "pattern").addListener(this).attachTo(column);
        support.addColumn(column);
        support.createColumns();
        this.bookmarks.getTable().setHeaderVisible(true);
        this.bookmarks.getTable().setLinesVisible(true);
        this.bookmarks.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.bookmarks.setInput((Object)this.client.getSettings().getBookmarks());
        this.bookmarks.refresh();
        new ContextMenu((Control)this.bookmarks.getTable(), this::fillContextMenu).hook();
        return container;
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.client.touch();
    }

    private void fillContextMenu(IMenuManager manager) {
        Bookmark bookmark = (Bookmark)((IStructuredSelection)this.bookmarks.getSelection()).getFirstElement();
        if (bookmark == null) {
            return;
        }
        if (!bookmark.isSeparator()) {
            this.addTestMenu(manager, bookmark);
        }
        this.addMoveUpAndDownActions(manager, bookmark);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.BookmarksListView_insertBefore){

            public void run() {
                Bookmark index = (Bookmark)((IStructuredSelection)BookmarksListTab.this.bookmarks.getSelection()).getFirstElement();
                Bookmark wl = new Bookmark(Messages.BookmarksListView_NewBookmark, BookmarksListTab.DEFAULT_URL);
                BookmarksListTab.this.client.getSettings().insertBookmark(index, wl);
                BookmarksListTab.this.client.touch();
                BookmarksListTab.this.bookmarks.setInput((Object)BookmarksListTab.this.client.getSettings().getBookmarks());
                BookmarksListTab.this.bookmarks.editElement((Object)wl, 0);
            }
        });
        manager.add((IAction)new Action(Messages.BookmarksListView_insertAfter){

            public void run() {
                Bookmark index = (Bookmark)((IStructuredSelection)BookmarksListTab.this.bookmarks.getSelection()).getFirstElement();
                Bookmark wl = new Bookmark(Messages.BookmarksListView_NewBookmark, BookmarksListTab.DEFAULT_URL);
                BookmarksListTab.this.client.getSettings().insertBookmarkAfter(index, wl);
                BookmarksListTab.this.client.touch();
                BookmarksListTab.this.bookmarks.setInput((Object)BookmarksListTab.this.client.getSettings().getBookmarks());
                BookmarksListTab.this.bookmarks.editElement((Object)wl, 0);
            }
        });
        manager.add((IAction)new Action(Messages.BookmarksListView_addSeparator){

            public void run() {
                Bookmark index = (Bookmark)((IStructuredSelection)BookmarksListTab.this.bookmarks.getSelection()).getFirstElement();
                Bookmark wl = new Bookmark("-", "");
                BookmarksListTab.this.client.getSettings().insertBookmarkAfter(index, wl);
                BookmarksListTab.this.client.touch();
                BookmarksListTab.this.bookmarks.setInput((Object)BookmarksListTab.this.client.getSettings().getBookmarks());
            }
        });
        manager.add((IContributionItem)new Separator());
        this.addSubmenuWithPlaceholders(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.BookmarksListView_delete){

            public void run() {
                ClientSettings settings = BookmarksListTab.this.client.getSettings();
                Object[] objectArray = ((IStructuredSelection)BookmarksListTab.this.bookmarks.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    settings.removeBookmark((Bookmark)element);
                    ++n2;
                }
                BookmarksListTab.this.client.touch();
                BookmarksListTab.this.bookmarks.setInput((Object)settings.getBookmarks());
            }
        });
    }

    private void addSubmenuWithPlaceholders(IMenuManager manager) {
        MenuManager submenu = new MenuManager(Messages.BookmarksListView_replacements);
        manager.add((IContributionItem)submenu);
        List<String> defaultReplacements = Arrays.asList("isin", "name", "wkn", "tickerSymbol", "tickerSymbolPrefix");
        submenu.add((IAction)new LabelOnly(Messages.BookmarksListView_LabelDefaultReplacements));
        defaultReplacements.forEach(r -> this.addReplacementMenu(submenu, (String)r));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)new LabelOnly(Messages.BookmarksListView_LabelAttributeReplacements));
        this.client.getSettings().getAttributeTypes().filter(a -> a.supports(Security.class)).filter(a -> !defaultReplacements.contains(a.getColumnLabel())).forEach(a -> this.addReplacementMenu(submenu, a.getColumnLabel()));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)new LabelOnly(Messages.BookmarksListView_LabelReplaceFirstAvailable));
        this.addReplacementMenu(submenu, "isin,wkn");
    }

    private void addReplacementMenu(MenuManager manager, String replacement) {
        manager.add((IAction)new SimpleAction(String.valueOf('{') + replacement + '}', a -> {
            Bookmark bookmark = (Bookmark)((IStructuredSelection)this.bookmarks.getSelection()).getFirstElement();
            bookmark.setPattern(String.valueOf(bookmark.getPattern()) + '{' + replacement + '}');
            this.bookmarks.refresh((Object)bookmark);
            this.client.touch();
        }));
    }

    private void addTestMenu(IMenuManager manager, Bookmark bookmark) {
        MenuManager securities = new MenuManager(Messages.MenuOpenSecurityOnSite);
        for (Security security : this.client.getSecurities()) {
            securities.add((IAction)new SimpleAction(security.getName(), a -> DesktopAPI.browse(bookmark.constructURL(this.client, security))));
        }
        manager.add((IContributionItem)securities);
        manager.add((IContributionItem)new Separator());
    }

    private void addMoveUpAndDownActions(IMenuManager manager, final Bookmark bookmark) {
        final int index = this.client.getSettings().getBookmarks().indexOf(bookmark);
        if (index > 0) {
            manager.add((IAction)new Action(Messages.MenuMoveUp){

                public void run() {
                    ClientSettings settings = BookmarksListTab.this.client.getSettings();
                    settings.removeBookmark(bookmark);
                    settings.insertBookmark(index - 1, bookmark);
                    BookmarksListTab.this.bookmarks.setInput((Object)BookmarksListTab.this.client.getSettings().getBookmarks());
                    BookmarksListTab.this.client.touch();
                }
            });
        }
        if (index < this.client.getSettings().getBookmarks().size() - 1) {
            manager.add((IAction)new Action(Messages.MenuMoveDown){

                public void run() {
                    ClientSettings settings = BookmarksListTab.this.client.getSettings();
                    settings.removeBookmark(bookmark);
                    settings.insertBookmark(index + 1, bookmark);
                    BookmarksListTab.this.bookmarks.setInput((Object)BookmarksListTab.this.client.getSettings().getBookmarks());
                    BookmarksListTab.this.client.touch();
                }
            });
        }
    }
}

