/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.settings;

import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.views.AbstractTabbedView;
import name.abuchen.portfolio.ui.views.settings.AttributeFieldType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AttributeListTab
implements AbstractTabbedView.Tab,
ColumnEditingSupport.ModificationListener {
    @Inject
    private Client client;
    @Inject
    private IPreferenceStore preferences;
    @Inject
    private Mode mode;
    private TableViewer tableViewer;

    @Override
    public String getTitle() {
        return String.valueOf(Messages.AttributeTypeTitle) + ": " + this.mode.getLabel();
    }

    @Override
    public void addButtons(ToolBarManager manager) {
        manager.add((IContributionItem)new DropDown(Messages.LabelNewFieldByType, Images.PLUS, 0, menuListener -> {
            menuListener.add((IAction)new LabelOnly(Messages.LabelNewFieldByType));
            AttributeFieldType[] attributeFieldTypeArray = AttributeFieldType.values();
            int n = attributeFieldTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                final AttributeFieldType fieldType = attributeFieldTypeArray[n2];
                if (fieldType.supports(this.mode.getType())) {
                    menuListener.add((IAction)new Action(fieldType.toString()){

                        public void run() {
                            AttributeType attributeType = new AttributeType(UUID.randomUUID().toString());
                            attributeType.setName(Messages.ColumnName);
                            attributeType.setColumnLabel(Messages.ColumnColumnLabel);
                            attributeType.setConverter(fieldType.getConverterClass());
                            attributeType.setType(fieldType.getFieldClass());
                            attributeType.setTarget(AttributeListTab.this.mode.getType());
                            AttributeListTab.this.client.getSettings().addAttributeType(attributeType);
                            AttributeListTab.this.tableViewer.setInput((Object)AttributeListTab.this.client.getSettings().getAttributeTypes().filter(t -> t.getTarget() == AttributeListTab.this.mode.getType()).toArray());
                            AttributeListTab.this.client.touch();
                            AttributeListTab.this.tableViewer.editElement((Object)attributeType, 0);
                        }
                    });
                }
                ++n2;
            }
        }));
    }

    @Override
    public Composite createTab(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(container, 65538);
        ColumnEditingSupport.prepare((ColumnViewer)this.tableViewer);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(AttributeListTab.class.getSimpleName()) + "@v2", this.preferences, this.tableViewer, layout);
        this.addColumns(support);
        support.createColumns();
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput((Object)this.client.getSettings().getAttributeTypes().filter(t -> t.getTarget() == this.mode.getType()).toArray());
        new ContextMenu((Control)this.tableViewer.getTable(), this::fillContextMenu).hook();
        return container;
    }

    private void addColumns(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnName, 0, 250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AttributeType)element).getName();
            }

            public Image getImage(Object element) {
                return Images.TEXT.image();
            }
        });
        new StringEditingSupport(AttributeType.class, "name").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnColumnLabel, 0, 150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AttributeType)element).getColumnLabel();
            }
        });
        new StringEditingSupport(AttributeType.class, "columnLabel").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnFieldType, 0, 150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return AttributeFieldType.of((AttributeType)element).toString();
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnSource, 0, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AttributeType)element).getSource();
            }
        });
        support.addColumn(column);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        AttributeType attributeType = (AttributeType)selection.getFirstElement();
        if (selection.size() == 1) {
            this.addMoveUpAndDownActions(manager, attributeType);
        }
        manager.add((IContributionItem)new Separator());
        this.addDeleteActions(manager, selection);
    }

    private void addMoveUpAndDownActions(IMenuManager manager, final AttributeType attributeType) {
        final int index = this.tableViewer.getTable().getSelectionIndex();
        if (index < 0) {
            return;
        }
        if (index > 0) {
            manager.add((IAction)new Action(Messages.MenuMoveUp){

                public void run() {
                    AttributeType above = (AttributeType)AttributeListTab.this.tableViewer.getTable().getItem(index - 1).getData();
                    int insertAt = AttributeListTab.this.client.getSettings().getAttributeTypeIndexOf(above);
                    AttributeListTab.this.moveAttribute(attributeType, insertAt);
                }
            });
        }
        if (index < this.tableViewer.getTable().getItemCount() - 1) {
            manager.add((IAction)new Action(Messages.MenuMoveDown){

                public void run() {
                    AttributeType below = (AttributeType)AttributeListTab.this.tableViewer.getTable().getItem(index + 1).getData();
                    int insertAt = AttributeListTab.this.client.getSettings().getAttributeTypeIndexOf(below);
                    AttributeListTab.this.moveAttribute(attributeType, insertAt);
                }
            });
        }
    }

    private void moveAttribute(AttributeType attributeType, int insertAt) {
        ClientSettings settings = this.client.getSettings();
        settings.removeAttributeType(attributeType);
        settings.addAttributeType(insertAt, attributeType);
        this.tableViewer.setInput((Object)this.client.getSettings().getAttributeTypes().filter(t -> t.getTarget() == this.mode.getType()).toArray());
        this.client.touch();
    }

    private void addDeleteActions(IMenuManager manager, final IStructuredSelection selection) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.BookmarksListView_delete){

            public void run() {
                ClientSettings settings = AttributeListTab.this.client.getSettings();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    AttributeType attribute = (AttributeType)element;
                    for (Attributable attributable : AttributeListTab.this.mode.getObjects(AttributeListTab.this.client)) {
                        attributable.getAttributes().remove(attribute);
                    }
                    settings.removeAttributeType(attribute);
                    ++n2;
                }
                AttributeListTab.this.client.touch();
                AttributeListTab.this.tableViewer.setInput((Object)settings.getAttributeTypes().filter(t -> t.getTarget() == AttributeListTab.this.mode.getType()).toArray());
            }
        });
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.client.touch();
    }

    static enum Mode {
        SECURITY(Security.class, Messages.LabelSecurities, client -> client.getSecurities()),
        ACCOUNT(Account.class, Messages.LabelAccounts, client -> client.getAccounts()),
        PORTFOLIO(Portfolio.class, Messages.LabelPortfolios, client -> client.getPortfolios()),
        INVESTMENT_PLAN(InvestmentPlan.class, Messages.LabelInvestmentPlans, client -> client.getPlans());

        private final Class<? extends Attributable> type;
        private final String label;
        private final Function<Client, List<? extends Attributable>> listFunction;

        private Mode(Class<? extends Attributable> type, String label, Function<Client, List<? extends Attributable>> listFunction) {
            this.type = type;
            this.label = label;
            this.listFunction = listFunction;
        }

        public Class<? extends Attributable> getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public List<? extends Attributable> getObjects(Client client) {
            return this.listFunction.apply(client);
        }
    }
}

