/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.earnings.EarningsAccumulatedChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerMonthChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerMonthMatrixTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerQuarterChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerQuarterMatrixTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerYearChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerYearMatrixTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.ui.views.earnings.StartYearSelectionDropDown;
import name.abuchen.portfolio.ui.views.earnings.TransactionsTab;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EarningsView
extends AbstractFinanceView {
    private static final String KEY_TAB = String.valueOf(EarningsView.class.getSimpleName()) + "-tab";
    private static final String KEY_YEAR = String.valueOf(EarningsView.class.getSimpleName()) + "-year";
    private static final String KEY_MODE = String.valueOf(EarningsView.class.getSimpleName()) + "-mode";
    private static final String KEY_USE_GROSS_VALUE = String.valueOf(EarningsView.class.getSimpleName()) + "-use-gross-value";
    @Inject
    private Client client;
    @Inject
    private IPreferenceStore preferences;
    @Inject
    private ExchangeRateProviderFactory factory;
    private EarningsViewModel model;
    private CTabFolder folder;

    @PostConstruct
    public void setupModel() {
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.client.getBaseCurrency());
        this.model = new EarningsViewModel(this.preferences, (CurrencyConverter)converter, this.client);
        int year = this.preferences.getInt(KEY_YEAR);
        LocalDate now = LocalDate.now();
        if (year < 1900 || year > now.getYear()) {
            year = now.getYear() - 2;
        }
        EarningsViewModel.Mode mode = EarningsViewModel.Mode.ALL;
        String prefMode = this.preferences.getString(KEY_MODE);
        if (prefMode != null && !prefMode.isEmpty()) {
            try {
                mode = EarningsViewModel.Mode.valueOf(prefMode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean useGrossValue = this.preferences.getBoolean(KEY_USE_GROSS_VALUE);
        this.model.configure(year, mode, useGrossValue);
        this.model.addUpdateListener(() -> {
            this.preferences.setValue(KEY_YEAR, this.model.getStartYear());
            this.preferences.setValue(KEY_MODE, this.model.getMode().name());
            this.preferences.setValue(KEY_USE_GROSS_VALUE, this.model.usesGrossValue());
        });
    }

    @Override
    public void notifyModelUpdated() {
        this.model.recalculate();
    }

    @Override
    protected String getDefaultTitle() {
        return this.model.getMode().getLabel();
    }

    @Override
    protected void addViewButtons(ToolBarManager toolBarManager) {
        EarningsViewModel.Mode[] modeArray = EarningsViewModel.Mode.values();
        int n = modeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EarningsViewModel.Mode mode = modeArray[n2];
            ActionContributionItem item = new ActionContributionItem((IAction)new SimpleAction(TextUtil.tooltip((String)mode.getLabel()), a -> {
                this.model.setMode(mode);
                this.updateIcons(toolBarManager);
                this.updateTitle(this.model.getMode().getLabel());
            }));
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            toolBarManager.add((IContributionItem)item);
            ++n2;
        }
        this.updateIcons(toolBarManager);
    }

    private void updateIcons(ToolBarManager toolBarManager) {
        int index = 0;
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            Images image = index == this.model.getMode().ordinal() ? Images.VIEW_SELECTED : Images.VIEW;
            ((ActionContributionItem)item).getAction().setImageDescriptor(image.descriptor());
            ++index;
            ++n2;
        }
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new StartYearSelectionDropDown(this.model));
        DropDown dropDown = new DropDown(Messages.MenuChooseClientFilter, this.model.getClientFilterMenu().hasActiveFilter() ? Images.FILTER_ON : Images.FILTER_OFF, 0, this.model.getClientFilterMenu()::menuAboutToShow);
        this.model.getClientFilterMenu().addListener(f -> dropDown.setImage(this.model.getClientFilterMenu().hasActiveFilter() ? Images.FILTER_ON : Images.FILTER_OFF));
        toolBar.add((IContributionItem)dropDown);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuExportData, Images.EXPORT, 0, manager -> {
            int itemCount = this.folder.getItemCount();
            int ii = 0;
            while (ii < itemCount) {
                EarningsTab tab = (EarningsTab)this.folder.getItem(ii).getData();
                if (tab != null) {
                    tab.addExportActions(manager);
                }
                ++ii;
            }
        }));
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureView, Images.CONFIG, 0, manager -> {
            EarningsTab tab;
            EnumSet<EarningsViewModel.Mode> supportGrossValue = EnumSet.of(EarningsViewModel.Mode.DIVIDENDS, EarningsViewModel.Mode.INTEREST, EarningsViewModel.Mode.EARNINGS);
            if (supportGrossValue.contains((Object)this.model.getMode())) {
                SimpleAction action = new SimpleAction(Messages.LabelUseGrossValue, a -> this.model.setUseGrossValue(!this.model.usesGrossValue()));
                action.setChecked(this.model.usesGrossValue());
                manager.add((IAction)action);
            }
            if ((tab = (EarningsTab)this.folder.getSelection().getData()) != null) {
                manager.add((IContributionItem)new Separator());
                tab.addConfigActions(manager);
            }
        }));
    }

    @Override
    protected Control createBody(Composite parent) {
        this.folder = new CTabFolder(parent, 2048);
        this.createTab(this.folder, Images.VIEW_TABLE, EarningsPerMonthMatrixTab.class);
        this.createTab(this.folder, Images.VIEW_TABLE, EarningsPerQuarterMatrixTab.class);
        this.createTab(this.folder, Images.VIEW_TABLE, EarningsPerYearMatrixTab.class);
        this.createTab(this.folder, Images.VIEW_BARCHART, EarningsPerMonthChartTab.class);
        this.createTab(this.folder, Images.VIEW_BARCHART, EarningsPerQuarterChartTab.class);
        this.createTab(this.folder, Images.VIEW_BARCHART, EarningsPerYearChartTab.class);
        this.createTab(this.folder, Images.VIEW_LINECHART, EarningsAccumulatedChartTab.class);
        this.createTab(this.folder, Images.VIEW_TABLE, TransactionsTab.class);
        int tab = this.preferences.getInt(KEY_TAB);
        if (tab < 0 || tab > 7) {
            tab = 0;
        }
        this.folder.setSelection(tab);
        this.folder.addDisposeListener(e -> this.preferences.setValue(KEY_TAB, this.folder.getSelectionIndex()));
        return this.folder;
    }

    private void createTab(CTabFolder folder, Images image, Class<? extends EarningsTab> tabClass) {
        EarningsTab tab = this.make(tabClass, this.model);
        Control control = tab.createControl((Composite)folder);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(tab.getLabel());
        item.setControl(control);
        item.setData((Object)tab);
        item.setImage(image.image());
    }
}

