/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.function.ToLongFunction;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerMonthMatrixTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Widget;

public class EarningsPerYearMatrixTab
extends EarningsPerMonthMatrixTab {
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

    @Override
    public String getLabel() {
        return Messages.LabelEarningsByYearAndVehicle;
    }

    @Override
    public void addConfigActions(IMenuManager manager) {
    }

    @Override
    protected void createColumns(TableViewer records, TableColumnLayout layout) {
        this.createVehicleColumn(records, layout, true);
        LocalDate date = LocalDate.of(this.model.getStartYear(), Month.JANUARY, 1);
        int index = 0;
        while (index < this.model.getNoOfMonths()) {
            this.createYearColumn(records, layout, date, index);
            date = date.plusYears(1L);
            index += 12;
        }
        this.createSumColumn(records, layout);
    }

    private void createYearColumn(TableViewer records, TableColumnLayout layout, LocalDate start, int index) {
        final ToLongFunction<EarningsViewModel.Line> valueFunction = line -> {
            long value = 0L;
            int ii = index;
            while (ii < index + 12 && ii < line.getNoOfMonths()) {
                value += line.getValue(ii);
                ++ii;
            }
            return value;
        };
        TableViewerColumn column = new TableViewerColumn(records, 131072);
        column.getColumn().setText(this.formatter.format(start));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarningsViewModel.Line line = (EarningsViewModel.Line)element;
                long value = valueFunction.applyAsLong(line);
                return line.getVehicle() != null ? Values.Amount.formatNonZero((Object)value) : Values.Amount.format((Object)value);
            }

            public String getToolTipText(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return TextUtil.tooltip((String)(vehicle != null ? vehicle.getName() : null));
            }

            public Font getFont(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return vehicle != null ? null : EarningsPerYearMatrixTab.this.boldFont;
            }
        });
        this.createSorter((l1, l2) -> Long.compare(valueFunction.applyAsLong((EarningsViewModel.Line)l1), valueFunction.applyAsLong((EarningsViewModel.Line)l2))).attachTo((ColumnViewer)records, (ViewerColumn)column);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(50));
    }
}

