/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.function.ToLongFunction;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.earnings.EarningsPerMonthMatrixTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Widget;

public class EarningsPerQuarterMatrixTab
extends EarningsPerMonthMatrixTab {
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");

    @Override
    public String getLabel() {
        return Messages.LabelEarningsByQuarterAndVehicle;
    }

    @Override
    public void addConfigActions(IMenuManager manager) {
    }

    @Override
    protected void createColumns(TableViewer records, TableColumnLayout layout) {
        this.createVehicleColumn(records, layout, true);
        this.createQuarterColumns(records, layout);
        this.createSumColumn(records, layout);
    }

    private void createQuarterColumns(TableViewer records, TableColumnLayout layout) {
        LocalDate date = LocalDate.of(this.model.getStartYear(), Month.JANUARY, 1);
        int nMonths = this.model.getNoOfMonths();
        int monthInQuarter = 3;
        int nQuarters = (int)Math.ceil((double)nMonths / (double)monthInQuarter);
        int quarterBeginIndex = 0;
        int quarterEndIndex = Math.min(monthInQuarter, nMonths);
        int quarter = 0;
        while (quarter < nQuarters) {
            int quarterWithinYear = quarter % 4 + 1;
            String columnCaption = String.format("Q%d %s", quarterWithinYear, this.formatter.format(date));
            this.createQuarterColumn(records, layout, quarterBeginIndex, quarterEndIndex, columnCaption);
            quarterBeginIndex = Math.min(quarterBeginIndex + monthInQuarter, nMonths);
            quarterEndIndex = Math.min(quarterEndIndex + monthInQuarter, nMonths);
            if (quarterWithinYear == 4) {
                date = date.plusYears(1L);
            }
            ++quarter;
        }
    }

    private void createQuarterColumn(TableViewer records, TableColumnLayout layout, int quarterBeginIndex, int quarterEndIndex, String columnCaption) {
        final ToLongFunction<EarningsViewModel.Line> valueFunction = line -> {
            long value = 0L;
            int i = quarterBeginIndex;
            while (i < quarterEndIndex) {
                value += line.getValue(i);
                ++i;
            }
            return value;
        };
        TableViewerColumn column = new TableViewerColumn(records, 131072);
        column.getColumn().setText(columnCaption);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarningsViewModel.Line line = (EarningsViewModel.Line)element;
                long value = valueFunction.applyAsLong(line);
                return line.getVehicle() != null ? Values.Amount.formatNonZero((Object)value) : Values.Amount.format((Object)value);
            }

            public String getToolTipText(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return TextUtil.tooltip((String)(vehicle != null ? vehicle.getName() : null));
            }

            public Font getFont(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return vehicle != null ? null : EarningsPerQuarterMatrixTab.this.boldFont;
            }
        });
        this.createSorter((l1, l2) -> Long.compare(valueFunction.applyAsLong((EarningsViewModel.Line)l1), valueFunction.applyAsLong((EarningsViewModel.Line)l2))).attachTo((ColumnViewer)records, (ViewerColumn)column);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(50));
    }
}

