/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.function.ToLongFunction;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.views.AccountContextMenu;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.earnings.EarningsTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class EarningsPerMonthMatrixTab
implements EarningsTab {
    @Inject
    private AbstractFinanceView view;
    @Inject
    private SelectionService selectionService;
    @Inject
    protected EarningsViewModel model;
    private boolean showOnlyOneYear = false;
    protected Font boldFont;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM yy");
    private TableColumnLayout tableLayout;
    private TableViewer tableViewer;

    @Override
    public String getLabel() {
        return Messages.LabelEarningsByMonthAndVehicle;
    }

    @Override
    public void addExportActions(IMenuManager manager) {
        manager.add((IAction)new Action(MessageFormat.format(Messages.LabelExport, this.getLabel())){

            public void run() {
                new TableViewerCSVExporter(EarningsPerMonthMatrixTab.this.tableViewer).export(String.valueOf(EarningsPerMonthMatrixTab.this.getLabel()) + ".csv");
            }
        });
    }

    @Override
    public void addConfigActions(IMenuManager manager) {
        SimpleAction action = new SimpleAction(Messages.LabelShowOnlyOneYear, a -> {
            this.showOnlyOneYear = !this.showOnlyOneYear;
            this.updateColumns(this.tableViewer, this.tableLayout);
        });
        action.setChecked(this.showOnlyOneYear);
        manager.add((IAction)action);
    }

    @Override
    public Control createControl(Composite parent) {
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.boldFont = resources.createFont(FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1));
        Composite container = new Composite(parent, 0);
        this.tableLayout = new TableColumnLayout();
        container.setLayout((Layout)this.tableLayout);
        this.tableViewer = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.createColumns(this.tableViewer, this.tableLayout);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addSelectionChangedListener(event -> {
            InvestmentVehicle vehicle;
            IStructuredSelection selection = event.getStructuredSelection();
            if (!selection.isEmpty() && (vehicle = ((EarningsViewModel.Line)selection.getFirstElement()).getVehicle()) instanceof Security) {
                this.selectionService.setSelection(new SecuritySelection(this.model.getClient(), (Security)vehicle));
            }
        });
        this.tableViewer.setInput(this.model.getAllLines());
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
        this.model.addUpdateListener(() -> this.updateColumns(this.tableViewer, this.tableLayout));
        new ContextMenu(this.tableViewer.getControl(), this::fillContextMenu).hook();
        return container;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.tableViewer.getStructuredSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        EarningsViewModel.Line line = (EarningsViewModel.Line)selection.getFirstElement();
        InvestmentVehicle vehicle = line.getVehicle();
        if (vehicle instanceof Account) {
            new AccountContextMenu(this.view).menuAboutToShow(manager, (Account)vehicle, null);
        } else if (vehicle instanceof Security) {
            new SecurityContextMenu(this.view).menuAboutToShow(manager, (Security)vehicle);
        }
    }

    protected void createColumns(TableViewer records, TableColumnLayout layout) {
        this.createVehicleColumn(records, layout, true);
        LocalDate date = LocalDate.of(this.model.getStartYear(), Month.JANUARY, 1);
        int noOfMonths = this.showOnlyOneYear ? Math.min(12, this.model.getNoOfMonths()) : this.model.getNoOfMonths();
        int index = 0;
        while (index < noOfMonths) {
            this.createMonthColumn(records, layout, date, index);
            date = date.plusMonths(1L);
            ++index;
        }
        this.createSumColumn(records, layout);
        this.createVehicleColumn(records, layout, false);
    }

    protected void createVehicleColumn(TableViewer records, TableColumnLayout layout, boolean isSorted) {
        TableViewerColumn column = new TableViewerColumn(records, 0);
        column.getColumn().setText(Messages.ColumnSecurity);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return LogoManager.instance().getDefaultColumnImage(vehicle, EarningsPerMonthMatrixTab.this.model.getClient().getSettings());
            }

            public String getText(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return vehicle != null ? vehicle.getName() : Messages.ColumnSum;
            }

            public Font getFont(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return vehicle != null ? null : EarningsPerMonthMatrixTab.this.boldFont;
            }
        });
        this.createSorter((l1, l2) -> l1.getVehicle().getName().compareToIgnoreCase(l2.getVehicle().getName())).attachTo((ColumnViewer)records, (ViewerColumn)column, isSorted);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(200));
    }

    protected ColumnViewerSorter createSorter(Comparator<EarningsViewModel.Line> comparator) {
        return ColumnViewerSorter.create((o1, o2) -> {
            int direction = ColumnViewerSorter.SortingContext.getSortDirection();
            EarningsViewModel.Line line1 = (EarningsViewModel.Line)o1;
            EarningsViewModel.Line line2 = (EarningsViewModel.Line)o2;
            if (line1.getVehicle() == null) {
                return direction == 1024 ? 1 : -1;
            }
            if (line2.getVehicle() == null) {
                return direction == 1024 ? -1 : 1;
            }
            return comparator.compare(line1, line2);
        });
    }

    private void createMonthColumn(TableViewer records, TableColumnLayout layout, LocalDate start, final int index) {
        TableViewerColumn column = new TableViewerColumn(records, 131072);
        column.getColumn().setText(this.formatter.format(start));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarningsViewModel.Line line = (EarningsViewModel.Line)element;
                return line.getVehicle() != null ? Values.Amount.formatNonZero((Object)line.getValue(index)) : Values.Amount.format((Object)line.getValue(index));
            }

            public String getToolTipText(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return TextUtil.tooltip((String)(vehicle != null ? vehicle.getName() : null));
            }

            public Font getFont(Object element) {
                InvestmentVehicle vehicle = ((EarningsViewModel.Line)element).getVehicle();
                return vehicle != null ? null : EarningsPerMonthMatrixTab.this.boldFont;
            }
        });
        this.createSorter((l1, l2) -> Long.compare(l1.getValue(index), l2.getValue(index))).attachTo((ColumnViewer)records, (ViewerColumn)column);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(50));
    }

    protected void createSumColumn(TableViewer records, TableColumnLayout layout) {
        final ToLongFunction<EarningsViewModel.Line> valueFunction = line -> {
            if (this.showOnlyOneYear) {
                int noOfMonths = Math.min(12, line.getNoOfMonths());
                long sum = 0L;
                int ii = 0;
                while (ii < noOfMonths) {
                    sum += line.getValue(ii);
                    ++ii;
                }
                return sum;
            }
            return line.getSum();
        };
        TableViewerColumn column = new TableViewerColumn(records, 131072);
        column.getColumn().setText(Messages.ColumnSum);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EarningsViewModel.Line line = (EarningsViewModel.Line)element;
                return Values.Amount.formatNonZero((Object)valueFunction.applyAsLong(line));
            }

            public Font getFont(Object element) {
                return EarningsPerMonthMatrixTab.this.boldFont;
            }
        });
        this.createSorter((l1, l2) -> Long.compare(valueFunction.applyAsLong((EarningsViewModel.Line)l1), valueFunction.applyAsLong((EarningsViewModel.Line)l2))).attachTo((ColumnViewer)records, (ViewerColumn)column);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(200));
    }

    private void updateColumns(TableViewer records, TableColumnLayout layout) {
        try {
            records.getTable().setRedraw(false);
            int count = records.getTable().getColumnCount();
            this.createColumns(records, layout);
            int ii = 0;
            while (ii < count) {
                records.getTable().getColumn(0).dispose();
                ++ii;
            }
            records.setInput(this.model.getAllLines());
            TableColumn[] tableColumnArray = records.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.pack();
                ++n2;
            }
        }
        finally {
            records.refresh();
            records.getTable().setRedraw(true);
        }
    }
}

