/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.ConfigurationStore;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dataseries.BasicDataSeriesConfigurator;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSerializer;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class DataSeriesConfigurator
extends BasicDataSeriesConfigurator
implements ConfigurationStore.ConfigurationStoreOwner {
    private final String identifier;
    private final IPreferenceStore preferences;
    private final ConfigurationStore store;
    private Menu configContextMenu;

    public DataSeriesConfigurator(AbstractFinanceView view, DataSeries.UseCase useCase) {
        super(view.getClient(), new DataSeriesSet(view.getClient(), view.getPreferenceStore(), useCase));
        this.identifier = String.valueOf(view.getClass().getSimpleName()) + "-PICKER";
        this.preferences = view.getPreferenceStore();
        this.store = new ConfigurationStore(this.identifier, view.getClient(), this.preferences, this);
        this.setSelectedData(this.store.getActive());
        view.getControl().addDisposeListener(e -> this.widgetDisposed());
    }

    public void setToolBarManager(ToolBarManager toolBar) {
        this.store.setToolBarManager(toolBar);
    }

    public String getConfigurationName() {
        return this.store.getActiveName();
    }

    public void showMenu(Shell shell) {
        if (this.configContextMenu == null) {
            this.configContextMenu = this.createMenu(shell, this::configMenuAboutToShow);
        }
        this.configContextMenu.setVisible(true);
    }

    private Menu createMenu(Shell shell, IMenuListener listener) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(listener);
        return menuMgr.createContextMenu((Control)shell);
    }

    private void widgetDisposed() {
        if (this.configContextMenu != null && !this.configContextMenu.isDisposed()) {
            this.configContextMenu.dispose();
        }
    }

    @Override
    public void configMenuAboutToShow(IMenuManager manager) {
        super.configMenuAboutToShow(manager);
        manager.add((IAction)new SimpleAction(Messages.MenuResetChartSeries, a -> this.doResetSeries(null)));
    }

    protected void doResetSeries(String config) {
        this.setSeriesDataSet(new DataSeriesSet(this.getClient(), this.preferences, this.getUseCase()), config);
    }

    @Override
    protected void fireUpdate() {
        super.fireUpdate();
        this.store.updateActive(new DataSeriesSerializer().toString(this.getSelectedDataSeries()));
    }

    @Override
    protected String getActiveUUID() {
        return this.store.getActiveUUID();
    }

    @Override
    public void beforeConfigurationPicked() {
    }

    @Override
    public void onConfigurationPicked(String data) {
        this.doResetSeries(data);
    }
}

