/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.Locale;
import java.util.function.Function;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.swtchart.LineStyle;

public final class DataSeries {
    private Type type;
    private Object group;
    private Object instance;
    private String label;
    private boolean isLineChart = true;
    private boolean isBenchmark = false;
    private RGB color;
    private boolean showArea;
    private LineStyle lineStyle = LineStyle.SOLID;

    DataSeries(Type type, Object instance, String label, RGB color) {
        this(type, null, instance, label, color);
    }

    DataSeries(Type type, Object group, Object instance, String label, RGB color) {
        this.type = type;
        this.group = group;
        this.instance = instance;
        this.label = label;
        this.color = color;
    }

    public Type getType() {
        return this.type;
    }

    public Object getGroup() {
        return this.group;
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getLabel() {
        return this.isBenchmark() ? String.valueOf(this.label) + Messages.ChartSeriesBenchmarkSuffix : this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSearchLabel() {
        Classification parent;
        StringBuilder buf = new StringBuilder();
        buf.append(this.label);
        if (this.instance instanceof Classification && (parent = ((Classification)this.instance).getParent()).getParent() != null) {
            buf.append(" (").append(parent.getPathName(false)).append(")");
        }
        if (this.isBenchmark()) {
            buf.append(Messages.ChartSeriesBenchmarkSuffix);
        }
        return buf.toString();
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public RGB getColor() {
        return this.color;
    }

    public boolean isLineChart() {
        return this.isLineChart;
    }

    public void setLineChart(boolean isLineChart) {
        this.isLineChart = isLineChart;
    }

    public boolean isBenchmark() {
        return this.isBenchmark;
    }

    public void setBenchmark(boolean isBenchmark) {
        this.isBenchmark = isBenchmark;
    }

    public boolean isShowArea() {
        return this.showArea;
    }

    public void setShowArea(boolean showArea) {
        this.showArea = showArea;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public Image getImage() {
        switch (this.type) {
            case SECURITY: 
            case SECURITY_BENCHMARK: {
                return Images.SECURITY.image();
            }
            case ACCOUNT: 
            case ACCOUNT_PRETAX: {
                return Images.ACCOUNT.image();
            }
            case PORTFOLIO: 
            case PORTFOLIO_PRETAX: 
            case PORTFOLIO_PLUS_ACCOUNT: 
            case PORTFOLIO_PLUS_ACCOUNT_PRETAX: {
                return Images.PORTFOLIO.image();
            }
            case CLASSIFICATION: {
                return Images.CATEGORY.image();
            }
            case CLIENT_FILTER: 
            case CLIENT_FILTER_PRETAX: {
                return Images.FILTER_OFF.image();
            }
        }
        return null;
    }

    public String getUUID() {
        return this.type.buildUUID(this.instance);
    }

    public String toString() {
        return String.valueOf(this.getSearchLabel()) + " [" + this.getUUID() + "]";
    }

    public static enum ClientDataSeries {
        TOTALS,
        INVESTED_CAPITAL,
        ABSOLUTE_INVESTED_CAPITAL,
        TRANSFERALS,
        TAXES,
        ABSOLUTE_DELTA,
        ABSOLUTE_DELTA_ALL_RECORDS,
        DIVIDENDS,
        DIVIDENDS_ACCUMULATED,
        INTEREST,
        INTEREST_ACCUMULATED,
        DELTA_PERCENTAGE,
        INTEREST_CHARGE,
        INTEREST_CHARGE_ACCUMULATED,
        EARNINGS,
        EARNINGS_ACCUMULATED;

    }

    public static enum Type {
        CLIENT("Client-", i -> ((ClientDataSeries)((Object)((Object)i))).name().toLowerCase(Locale.US)),
        CLIENT_PRETAX("Client-PreTax-", i -> ((ClientDataSeries)((Object)((Object)i))).name().toLowerCase(Locale.US)),
        SECURITY("Security", i -> ((Security)i).getUUID()),
        SECURITY_BENCHMARK("[b]Security", i -> ((Security)i).getUUID()),
        ACCOUNT("Account", i -> ((Account)i).getUUID()),
        ACCOUNT_PRETAX("Account-PreTax", i -> ((Account)i).getUUID()),
        PORTFOLIO("Portfolio", i -> ((Portfolio)i).getUUID()),
        PORTFOLIO_PRETAX("Portfolio-PreTax", i -> ((Portfolio)i).getUUID()),
        PORTFOLIO_PLUS_ACCOUNT("[+]Portfolio", i -> ((Portfolio)i).getUUID()),
        PORTFOLIO_PLUS_ACCOUNT_PRETAX("[+]Portfolio-PreTax", i -> ((Portfolio)i).getUUID()),
        CLASSIFICATION("Classification", i -> ((Classification)i).getId()),
        CLIENT_FILTER("ClientFilter", i -> ((ClientFilterMenu.Item)i).getUUIDs().replaceAll(",", "")),
        CLIENT_FILTER_PRETAX("ClientFilter-PreTax", i -> ((ClientFilterMenu.Item)i).getUUIDs().replaceAll(",", ""));

        private final String label;
        private final Function<Object, String> uuidProvider;

        private Type(String label, Function<Object, String> uuidProvider) {
            this.label = label;
            this.uuidProvider = uuidProvider;
        }

        String buildUUID(Object instance) {
            return String.valueOf(this.label) + this.uuidProvider.apply(instance);
        }
    }

    public static enum UseCase {
        STATEMENT_OF_ASSETS,
        PERFORMANCE,
        RETURN_VOLATILITY;

    }
}

