/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ConfigurationSet;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSelectionDialog;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSerializer;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;

public class BasicDataSeriesConfigurator {
    public static final String IDENTIFIER_POSTFIX = "-PICKER";
    private final Client client;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private DataSeriesSet dataSeriesSet;
    private List<DataSeries> selectedSeries = new ArrayList<DataSeries>();

    public BasicDataSeriesConfigurator(Client client, DataSeriesSet dataSeriesSet) {
        this.client = client;
        this.dataSeriesSet = dataSeriesSet;
        this.selectedSeries = new DataSeriesSerializer().fromString(dataSeriesSet, null);
    }

    protected Client getClient() {
        return this.client;
    }

    public DataSeries.UseCase getUseCase() {
        return this.dataSeriesSet.getUseCase();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected void fireUpdate() {
        this.listeners.forEach(Listener::onUpdate);
    }

    public List<DataSeries> getSelectedDataSeries() {
        return this.selectedSeries;
    }

    public void setSelectedData(String config) {
        this.selectedSeries = new DataSeriesSerializer().fromString(this.dataSeriesSet, config);
        this.fireUpdate();
    }

    protected void setSeriesDataSet(DataSeriesSet newSet, String newConfig) {
        this.dataSeriesSet = newSet;
        this.selectedSeries = new DataSeriesSerializer().fromString(this.dataSeriesSet, newConfig);
        this.fireUpdate();
    }

    public void configMenuAboutToShow(IMenuManager manager) {
        for (DataSeries series : this.selectedSeries) {
            SimpleAction action = new SimpleAction(series.getLabel(), a -> this.doDeleteSeries(series));
            action.setChecked(true);
            manager.add((IAction)action);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.ChartSeriesPickerAddItem, a -> this.doAddSeries(false)));
        if (this.dataSeriesSet.getUseCase() != DataSeries.UseCase.STATEMENT_OF_ASSETS) {
            manager.add((IAction)new SimpleAction(Messages.ChartSeriesPickerAddBenchmark, a -> this.doAddSeries(true)));
        }
        this.addCopyFromOtherChartsMenu(manager);
    }

    private void doAddSeries(boolean showOnlyBenchmark) {
        ArrayList<DataSeries> list = new ArrayList<DataSeries>(this.dataSeriesSet.getAvailableSeries());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (((DataSeries)iter.next()).isBenchmark() == showOnlyBenchmark) continue;
            iter.remove();
        }
        for (DataSeries s : this.selectedSeries) {
            list.remove(s);
        }
        DataSeriesSelectionDialog dialog = new DataSeriesSelectionDialog(Display.getDefault().getActiveShell());
        dialog.setElements(list);
        if (dialog.open() != 0) {
            return;
        }
        List<DataSeries> result = dialog.getResult();
        if (result.isEmpty()) {
            return;
        }
        result.forEach(series -> {
            boolean bl = this.selectedSeries.add((DataSeries)series);
        });
        this.fireUpdate();
    }

    private void addCopyFromOtherChartsMenu(IMenuManager manager) {
        String[] charts = new String[]{"StatementOfAssetsHistoryView", Messages.LabelStatementOfAssetsHistory, "PerformanceChartView", Messages.LabelPerformanceChart, "ReturnsVolatilityChartView", Messages.LabelHistoricalReturnsAndVolatiltity};
        MenuManager copyFromOthers = new MenuManager(Messages.ChartSeriesCopySeriesFromOtherChart);
        manager.add((IContributionItem)copyFromOthers);
        MenuManager replaceByOthers = new MenuManager(Messages.ChartSeriesReplaceSeriesByOtherChart);
        manager.add((IContributionItem)replaceByOthers);
        String currentConfigUUID = this.getActiveUUID();
        int ii = 0;
        while (ii < charts.length) {
            ConfigurationSet set = this.client.getSettings().getConfigurationSet(String.valueOf(charts[ii]) + IDENTIFIER_POSTFIX);
            MenuManager menuCopy = new MenuManager(charts[ii + 1]);
            copyFromOthers.add((IContributionItem)menuCopy);
            MenuManager menuReplace = new MenuManager(charts[ii + 1]);
            replaceByOthers.add((IContributionItem)menuReplace);
            set.getConfigurations().forEach(config -> {
                if (Objects.equals(currentConfigUUID, config.getUUID())) {
                    return;
                }
                menuCopy.add((IAction)new SimpleAction(config.getName(), a -> {
                    List<DataSeries> list = new DataSeriesSerializer().fromString(this.dataSeriesSet, config.getData());
                    list.stream().filter(s -> !this.selectedSeries.contains(s)).forEach(s -> {
                        boolean bl = this.selectedSeries.add((DataSeries)s);
                    });
                    this.fireUpdate();
                }));
                menuReplace.add((IAction)new SimpleAction(config.getName(), a -> {
                    List<DataSeries> list = new DataSeriesSerializer().fromString(this.dataSeriesSet, config.getData());
                    this.selectedSeries.clear();
                    list.stream().forEach(s -> {
                        boolean bl = this.selectedSeries.add((DataSeries)s);
                    });
                    this.fireUpdate();
                }));
            });
            ii += 2;
        }
    }

    protected String getActiveUUID() {
        return null;
    }

    protected void doDeleteSeries(DataSeries series) {
        this.selectedSeries.remove(series);
        this.fireUpdate();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onUpdate();
    }
}

