/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class SimpleGridLayout
extends Layout {
    private int numColumns = 1;
    private int numRows = 1;
    private int rowHeight = 20;

    SimpleGridLayout() {
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int width = this.numColumns * this.rowHeight;
        int height = this.numRows * this.rowHeight;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return;
        }
        int width = rect.width / this.numColumns;
        int height = rect.height / this.numRows;
        int column = 0;
        int row = 0;
        int index = 0;
        while (index < children.length) {
            if (column >= this.numColumns) {
                column = 0;
                ++row;
            }
            children[index].setBounds(rect.x + column * width, rect.y + row * height, width - 1, height - 1);
            ++column;
            ++index;
        }
    }
}

