/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.ReportingPeriodDialog;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;

public class ReportingPeriodConfig
implements WidgetConfig {
    private final WidgetDelegate<?> delegate;
    private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
    private ReportingPeriod reportingPeriod;

    public ReportingPeriodConfig(WidgetDelegate<?> delegate) {
        this.delegate = delegate;
        String code = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.REPORTING_PERIOD.name());
        try {
            if (code != null && !code.isEmpty()) {
                this.reportingPeriod = ReportingPeriod.from((String)code);
            }
        }
        catch (IOException ignore) {
            PortfolioPlugin.log(ignore);
        }
    }

    public ReportingPeriod getReportingPeriod() {
        return this.reportingPeriod != null ? this.reportingPeriod : this.delegate.getDashboardData().getDefaultReportingPeriod();
    }

    public void setReportingPeriod(ReportingPeriod reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
        if (reportingPeriod != null) {
            this.delegate.getWidget().getConfiguration().put(Dashboard.Config.REPORTING_PERIOD.name(), reportingPeriod.getCode());
        } else {
            this.delegate.getWidget().getConfiguration().remove(Dashboard.Config.REPORTING_PERIOD.name());
        }
        this.delegate.update();
        this.delegate.getClient().touch();
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        manager.appendToGroup("info", (IAction)new LabelOnly(this.getReportingPeriod().toString()));
        MenuManager subMenu = new MenuManager(Messages.LabelReportingPeriod);
        subMenu.add((IAction)new LabelOnly(this.reportingPeriod != null ? this.getReportingPeriod().toString() : Messages.LabelUsingDashboardDefaultReportingPeriod));
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)new SimpleAction(Messages.MenuUseDashboardDefaultReportingPeriod, a -> this.setReportingPeriod(null)));
        this.delegate.getDashboardData().getDefaultReportingPeriods().stream().forEach(p -> subMenu.add((IAction)new SimpleAction(p.toString(), a -> this.setReportingPeriod((ReportingPeriod)p))));
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)new SimpleAction(Messages.LabelReportingAddPeriod, a -> {
            ReportingPeriodDialog dialog = new ReportingPeriodDialog(Display.getDefault().getActiveShell(), this.getReportingPeriod());
            if (dialog.open() == 0) {
                ReportingPeriod rp = dialog.getReportingPeriod();
                if (!this.delegate.getDashboardData().getDefaultReportingPeriods().contains(rp)) {
                    this.delegate.getDashboardData().getDefaultReportingPeriods().add(rp);
                }
                this.setReportingPeriod(rp);
            }
        }));
        manager.add((IContributionItem)subMenu);
    }

    @Override
    public String getLabel() {
        StringBuilder label = new StringBuilder();
        label.append(Messages.LabelReportingPeriod).append(": ");
        label.append(this.getReportingPeriod().toString());
        Interval interval = this.getReportingPeriod().toInterval(LocalDate.now());
        label.append(" (").append(this.formatter.format(interval.getStart())).append(" - ").append(this.formatter.format(interval.getEnd())).append(")");
        if (this.reportingPeriod == null) {
            label.append(" | ").append(Messages.LabelUsingDashboardDefaultReportingPeriod);
        }
        return label.toString();
    }
}

