/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.ReportingPeriodDialog;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ReportingPeriodApplyToAll {
    private DashboardData dashboardData;

    public ReportingPeriodApplyToAll(DashboardData dashboardData) {
        this.dashboardData = dashboardData;
    }

    public void menuAboutToShow(MenuManager manager, Composite columnControl) {
        MenuManager subMenu = new MenuManager(Messages.LabelReportingPeriod);
        subMenu.add((IAction)new SimpleAction(Messages.MenuUseDashboardDefaultReportingPeriod, a -> this.apply(null, columnControl)));
        this.dashboardData.getDefaultReportingPeriods().stream().forEach(p -> subMenu.add((IAction)new SimpleAction(p.toString(), a -> this.apply((ReportingPeriod)p, columnControl))));
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)new SimpleAction(Messages.LabelReportingAddPeriod, a -> {
            ReportingPeriodDialog dialog = new ReportingPeriodDialog(Display.getDefault().getActiveShell(), this.dashboardData.getDefaultReportingPeriod());
            if (dialog.open() == 0) {
                ReportingPeriod reportingPeriod = dialog.getReportingPeriod();
                if (!this.dashboardData.getDefaultReportingPeriods().contains(reportingPeriod)) {
                    this.dashboardData.getDefaultReportingPeriods().add(reportingPeriod);
                }
                this.apply(reportingPeriod, columnControl);
            }
        }));
        manager.add((IContributionItem)subMenu);
    }

    private void apply(ReportingPeriod reportingPeriod, Composite columnControl) {
        Control[] controlArray = columnControl.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            WidgetDelegate delegate = (WidgetDelegate)child.getData("$delegate");
            if (delegate != null) {
                delegate.optionallyGet(ReportingPeriodConfig.class).ifPresent(config -> config.setReportingPeriod(reportingPeriod));
            }
            ++n2;
        }
    }
}

