/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.CacheKey;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.views.dashboard.ClientFilterConfig;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.EnumBasedConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.Pair;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class ActivityWidget
extends WidgetDelegate<List<TransactionPair<?>>> {
    private Label title;
    private Chart chart;
    private TimelineChartToolTip toolTip;
    private CurrencyConverter converter;

    public ActivityWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ReportingPeriodConfig(this));
        this.addConfig(new ClientFilterConfig(this));
        this.addConfig(new ChartTypeConfig(this));
        this.converter = data.getCurrencyConverter();
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        container.setBackground(parent.getBackground());
        this.title = new Label(container, 0);
        this.title.setBackground(container.getBackground());
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title);
        this.chart = new Chart(container, 0);
        this.chart.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"chart");
        this.getDashboardData().getStylingEngine().style((Object)this.chart);
        this.chart.setBackground(container.getBackground());
        this.chart.getTitle().setVisible(false);
        this.chart.getTitle().setText(this.title.getText());
        this.chart.getLegend().setVisible(false);
        this.toolTip = new TimelineChartToolTip(this.chart);
        this.toolTip.enableCategory(true);
        this.toolTip.reverseLabels(true);
        this.toolTip.setValueFormat(new DecimalFormat("#"));
        this.toolTip.setXAxisFormat(obj -> {
            Integer index = (Integer)obj;
            List yearMonths = (List)this.chart.getData();
            return ((YearMonth)yearMonths.get(index)).toString();
        });
        GC gc = new GC((Drawable)container);
        gc.setFont(resources.getKpiFont());
        Point stringExtend = gc.stringExtent("X");
        gc.dispose();
        GridDataFactory.fillDefaults().hint(-1, stringExtend.y * 7).grab(true, false).applyTo((Control)this.chart);
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTick().setVisible(true);
        xAxis.getTitle().setVisible(false);
        xAxis.getTitle().setText(Messages.ColumnMonth);
        xAxis.getGrid().setStyle(LineStyle.NONE);
        xAxis.enableCategory(true);
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.setPosition(IAxis.Position.Secondary);
        this.chart.getPlotArea().addTraverseListener(event -> {
            boolean bl = event.doit = true;
        });
        ((IPlotArea)this.chart.getPlotArea()).addCustomPaintListener((ICustomPaintListener)new TimeGridPaintListener(this.chart));
        container.layout();
        return container;
    }

    @Override
    public Supplier<List<TransactionPair<?>>> getUpdateTask() {
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
        ClientFilter clientFilter = this.get(ClientFilterConfig.class).getSelectedFilter();
        CacheKey key = new CacheKey(TransactionPair.class, clientFilter, interval);
        return () -> (List)this.getDashboardData().getCache().computeIfAbsent(key, k -> clientFilter.filter(this.getClient()).getAllTransactions());
    }

    @Override
    public void update(List<TransactionPair<?>> transactions) {
        try {
            this.chart.suspendUpdate(true);
            this.chart.getTitle().setText(this.title.getText());
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            ChartType chartType = (ChartType)((Object)this.get(ChartTypeConfig.class).getValue());
            this.toolTip.setValueFormat(new DecimalFormat(chartType == ChartType.COUNT ? "#" : "#,##0.00"));
            IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
            Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
            List yearMonths = interval.getYearMonths();
            this.chart.setData((Object)yearMonths);
            xAxis.setCategorySeries(yearMonths.stream().map(ym -> String.valueOf(ym.getMonthValue())).collect(Collectors.toList()).toArray(new String[0]));
            this.createSeries(chartType, interval, transactions, yearMonths, PortfolioTransaction.Type.BUY, Colors.ICON_BLUE);
            this.createSeries(chartType, interval, transactions, yearMonths, PortfolioTransaction.Type.DELIVERY_INBOUND, Colors.brighter(Colors.ICON_BLUE));
            this.createSeries(chartType, interval, transactions, yearMonths, PortfolioTransaction.Type.SELL, Colors.ICON_ORANGE);
            this.createSeries(chartType, interval, transactions, yearMonths, PortfolioTransaction.Type.DELIVERY_OUTBOUND, Colors.brighter(Colors.ICON_ORANGE));
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        try {
            this.chart.setRedraw(false);
            this.chart.getAxisSet().adjustRange();
        }
        finally {
            this.chart.setRedraw(true);
        }
    }

    private void createSeries(ChartType chartType, Interval interval, List<TransactionPair<?>> transactions, List<YearMonth> yearMonths, PortfolioTransaction.Type type, Color color) {
        IBarSeries barSeries = (IBarSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, type.toString());
        double[] series = new double[yearMonths.size()];
        for (TransactionPair<?> pair : transactions) {
            int indexOf;
            Optional tx;
            if (!interval.contains(pair.getTransaction().getDateTime()) || !(tx = pair.withPortfolioTransaction()).isPresent() || type != ((PortfolioTransaction)((TransactionPair)tx.get()).getTransaction()).getType() || (indexOf = yearMonths.indexOf(YearMonth.from(((PortfolioTransaction)((TransactionPair)tx.get()).getTransaction()).getDateTime()))) < 0) continue;
            switch (chartType) {
                case COUNT: {
                    int n = indexOf;
                    series[n] = series[n] + 1.0;
                    break;
                }
                case SUM: {
                    int n = indexOf;
                    series[n] = series[n] + (double)((PortfolioTransaction)((TransactionPair)tx.get()).getTransaction()).getMonetaryAmount(this.converter).getAmount() / Values.Amount.divider();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        barSeries.setYSeries(series);
        barSeries.setBarColor(color);
        barSeries.setBarPadding(25);
        barSeries.enableStack(true);
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    public static enum ChartType {
        COUNT(Messages.ColumnCount),
        SUM(Messages.ColumnSum);

        private String label;

        private ChartType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    static class ChartTypeConfig
    extends EnumBasedConfig<ChartType> {
        public ChartTypeConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.LabelChartType, ChartType.class, Dashboard.Config.AGGREGATION, EnumBasedConfig.Policy.EXACTLY_ONE);
        }
    }

    public static class TimeGridPaintListener
    implements ICustomPaintListener {
        private static final int INDENT = 5;
        private final Chart chart;

        public TimeGridPaintListener(Chart chart) {
            this.chart = chart;
        }

        public void paintControl(PaintEvent e) {
            List yearMonths = (List)this.chart.getData();
            if (yearMonths == null || yearMonths.isEmpty()) {
                return;
            }
            IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
            ArrayList<Pair> years = new ArrayList<Pair>();
            years.add(new Pair((Object)((YearMonth)yearMonths.get(0)).getYear(), (Object)xAxis.getPixelCoordinate(0.0)));
            int index = 1;
            while (index < yearMonths.size()) {
                YearMonth yearMonth = (YearMonth)yearMonths.get(index);
                if (yearMonth.getYear() != ((Integer)((Pair)years.get(years.size() - 1)).getKey()).intValue()) {
                    years.add(new Pair((Object)((YearMonth)yearMonths.get(index)).getYear(), (Object)xAxis.getPixelCoordinate((double)index)));
                }
                ++index;
            }
            index = 0;
            while (index < years.size()) {
                Pair pair = (Pair)years.get(index);
                int x = (Integer)pair.getValue();
                e.gc.drawLine(x, 0, x, e.height);
                int nextX = index + 1 < years.size() ? (Integer)((Pair)years.get(index + 1)).getValue() - 5 : e.width - 5;
                int availableWidth = nextX - x;
                String label = String.valueOf(pair.getKey());
                if (!this.drawLabel(e.gc, label, x, availableWidth)) {
                    label = String.format("%02d", (Integer)pair.getKey() % 100);
                    this.drawLabel(e.gc, label, x, availableWidth);
                }
                ++index;
            }
        }

        private boolean drawLabel(GC gc, String label, int x, int availableWidth) {
            Point point = gc.textExtent(label);
            if (point.x < availableWidth) {
                gc.drawText(label, x + 5, 5, true);
                return true;
            }
            return false;
        }

        public boolean drawBehindSeries() {
            return true;
        }
    }
}

