/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.DataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractIndicatorWidget<D>
extends WidgetDelegate<D> {
    protected Label title;
    protected ColoredLabel indicator;

    public AbstractIndicatorWidget(Dashboard.Widget widget, DashboardData dashboardData, boolean supportsBenchmarks) {
        super(widget, dashboardData);
        this.addConfig(new DataSeriesConfig(this, supportsBenchmarks));
        this.addConfig(new ReportingPeriodConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        this.title = new Label(container, 0);
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        this.title.setBackground(Colors.theme().defaultBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title);
        this.indicator = new ColoredLabel(container, 0);
        this.indicator.setFont(resources.getKpiFont());
        this.indicator.setBackground(Colors.theme().defaultBackground());
        this.indicator.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.indicator);
        return container;
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public void update(D data) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
    }
}

