/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.OptionLabelProvider;
import org.eclipse.swt.widgets.Shell;

public class TaxonomyColumn
extends Column {
    private static final int SHOW_FULL_CLASSIFICATION = 100;

    public TaxonomyColumn(Taxonomy taxonomy) {
        super(taxonomy.getId(), taxonomy.getName(), 16384, 120);
        TaxonomyLabelProvider labelProvider = new TaxonomyLabelProvider(taxonomy);
        this.setGroupLabel(Messages.ColumnTaxonomy);
        this.setOptions(new TaxonomyOptions(taxonomy));
        this.setLabelProvider(labelProvider);
        this.setComparator(new TaxonomyComparator(labelProvider));
    }

    private class TaxonomyComparator
    implements Comparator<Object> {
        private final TaxonomyLabelProvider labelProvider;

        public TaxonomyComparator(TaxonomyLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer option = (Integer)ColumnViewerSorter.SortingContext.getColumnOption();
            String s1 = this.labelProvider.getText(o1, option);
            String s2 = this.labelProvider.getText(o2, option);
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static final class TaxonomyLabelProvider
    extends OptionLabelProvider<Integer> {
        private final Taxonomy taxonomy;

        public TaxonomyLabelProvider(Taxonomy taxonomy) {
            this.taxonomy = taxonomy;
        }

        @Override
        public String getText(Object e, Integer option) {
            InvestmentVehicle vehicle = (InvestmentVehicle)Adaptor.adapt(InvestmentVehicle.class, (Object)e);
            if (vehicle == null) {
                return null;
            }
            List classifications = this.taxonomy.getClassifications(vehicle);
            if (classifications.isEmpty()) {
                return null;
            }
            StringBuilder answer = new StringBuilder();
            for (Classification c : classifications) {
                if (answer.length() > 0) {
                    answer.append(", ");
                }
                if (option == 100) {
                    answer.append(c.getPathName(false));
                    continue;
                }
                List path = c.getPathToRoot();
                if (option >= path.size()) continue;
                answer.append(((Classification)path.get(option)).getName());
            }
            return answer.toString();
        }
    }

    private static final class TaxonomyOptions
    implements Column.Options<Integer> {
        private final Taxonomy taxonomy;

        private TaxonomyOptions(Taxonomy taxonomy) {
            this.taxonomy = taxonomy;
        }

        @Override
        public List<Integer> getOptions() {
            List<Integer> elements = IntStream.range(1, this.taxonomy.getHeigth()).boxed().collect(Collectors.toList());
            elements.add(100);
            return elements;
        }

        @Override
        public Integer valueOf(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String toString(Integer option) {
            return option.toString();
        }

        @Override
        public String getColumnLabel(Integer option) {
            int index = option;
            if (index == 100) {
                return this.taxonomy.getName();
            }
            List labels = this.taxonomy.getDimensions();
            return labels != null && index < labels.size() ? (String)labels.get(index - 1) : MessageFormat.format(Messages.LabelLevelNameNumber, this.taxonomy.getName(), option);
        }

        @Override
        public String getMenuLabel(Integer option) {
            int index = option;
            if (index == 100) {
                return Messages.LabelFullClassification;
            }
            List labels = this.taxonomy.getDimensions();
            return labels != null && index <= labels.size() ? (String)labels.get(index - 1) : MessageFormat.format(Messages.LabelLevelNumber, option);
        }

        @Override
        public String getDescription(Integer option) {
            return null;
        }

        @Override
        public boolean canCreateNewOptions() {
            return false;
        }

        @Override
        public Integer createNewOption(Shell shell) {
            throw new UnsupportedOperationException();
        }
    }
}

