/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import java.text.MessageFormat;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.util.Isin;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class IsinColumn
extends Column {
    public IsinColumn() {
        this("isin");
    }

    public IsinColumn(String id) {
        super(id, Messages.ColumnISIN, 16384, 100);
        this.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Security s = (Security)Adaptor.adapt(Security.class, (Object)e);
                return s != null ? s.getIsin() : null;
            }
        });
        this.setSorter(ColumnViewerSorter.create(Security.class, "isin"));
        new IsinEditingSupport().attachTo(this);
    }

    public static class IsinEditingSupport
    extends ColumnEditingSupport {
        @Override
        public boolean canEdit(Object element) {
            Security s = (Security)Adaptor.adapt(Security.class, (Object)element);
            return s != null && !s.isExchangeRate() && s.getOnlineId() == null;
        }

        @Override
        public Object getValue(Object element) {
            Security s = (Security)Adaptor.adapt(Security.class, (Object)element);
            return s.getIsin() != null ? s.getIsin() : "";
        }

        @Override
        public void setValue(Object element, Object value) {
            String newValue = ((String)value).trim();
            if (newValue.length() > 0 && !Isin.isValid((String)newValue)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MsgDialogNotAValidISIN, newValue));
            }
            Security security = (Security)Adaptor.adapt(Security.class, (Object)element);
            String oldValue = security.getIsin();
            if (!newValue.equals(oldValue)) {
                security.setIsin(newValue);
                this.notify(element, newValue, oldValue);
            }
        }
    }
}

