/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.ListEditingSupport;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class CurrencyColumn
extends Column {
    public CurrencyColumn() {
        this("currency", Messages.ColumnCurrency, 16384, 60);
    }

    public CurrencyColumn(String id, String label, int style, int defaultWidth) {
        super(id, label, style, defaultWidth);
        this.setLabelProvider((CellLabelProvider)new CurrencyColumnLabelProvider());
        this.setSorter(ColumnViewerSorter.create(InvestmentVehicle.class, "currencyCode"));
    }

    private static class CurrencyColumnLabelProvider
    extends ColumnLabelProvider {
        private CurrencyColumnLabelProvider() {
        }

        public String getText(Object e) {
            InvestmentVehicle n = (InvestmentVehicle)Adaptor.adapt(InvestmentVehicle.class, (Object)e);
            return n != null ? n.getCurrencyCode() : null;
        }
    }

    public static class CurrencyEditingSupport
    extends ListEditingSupport {
        public CurrencyEditingSupport() {
            super(InvestmentVehicle.class, "currencyCode", CurrencyUnit.getAvailableCurrencyUnits().stream().map(u -> u.getCurrencyCode()).sorted().collect(Collectors.toList()));
        }
    }
}

