/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.actions;

import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import org.eclipse.jface.action.Action;

public class RevertDeliveryAction
extends Action {
    private final Client client;
    private final TransactionPair<PortfolioTransaction> transaction;

    public RevertDeliveryAction(Client client, TransactionPair<PortfolioTransaction> transaction) {
        this.client = client;
        this.transaction = transaction;
        if (((PortfolioTransaction)transaction.getTransaction()).getType() != PortfolioTransaction.Type.DELIVERY_INBOUND && ((PortfolioTransaction)transaction.getTransaction()).getType() != PortfolioTransaction.Type.DELIVERY_OUTBOUND) {
            throw new IllegalArgumentException();
        }
    }

    public void run() {
        PortfolioTransaction tx = (PortfolioTransaction)this.transaction.getTransaction();
        Money grossAmount = tx.getUnit(Transaction.Unit.Type.GROSS_VALUE).map(Transaction.Unit::getAmount).orElse(tx.getGrossValue());
        Money feesAndTaxes = (Money)tx.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.FEE || u.getType() == Transaction.Unit.Type.TAX).map(Transaction.Unit::getAmount).collect(MoneyCollectors.sum((String)tx.getCurrencyCode()));
        if (PortfolioTransaction.Type.DELIVERY_INBOUND.equals((Object)tx.getType())) {
            tx.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            tx.setMonetaryAmount(grossAmount.subtract(feesAndTaxes));
        } else if (PortfolioTransaction.Type.DELIVERY_OUTBOUND.equals((Object)tx.getType())) {
            tx.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            tx.setMonetaryAmount(grossAmount.add(feesAndTaxes));
        } else {
            throw new IllegalArgumentException();
        }
        this.client.markDirty();
    }
}

