/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.DateTimeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.TransactionOwnerListEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.TransactionTypeEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.TransactionContextMenu;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.SymbolColumn;
import name.abuchen.portfolio.ui.views.columns.WknColumn;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public final class TransactionsViewer
implements ColumnEditingSupport.ModificationListener {
    @Inject
    private SelectionService selectionService;
    private AbstractFinanceView owner;
    private Set<TransactionPair<?>> marked = new HashSet();
    private TableViewer tableViewer;
    private ShowHideColumnHelper support;
    private boolean fullContextMenu = true;
    private Menu contextMenu;

    public TransactionsViewer(Composite parent, AbstractFinanceView owner) {
        this(String.valueOf(TransactionsViewer.class.getSimpleName()) + "3", parent, owner);
    }

    public TransactionsViewer(String identifier, Composite parent, AbstractFinanceView owner) {
        this.owner = owner;
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(container, 65538);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        ColumnEditingSupport.prepare((ColumnViewer)this.tableViewer);
        this.support = new ShowHideColumnHelper(identifier, owner.getPreferenceStore(), this.tableViewer, layout);
        this.addColumns();
        this.support.createColumns();
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addSelectionChangedListener(event -> {
            if (event.getSelection().isEmpty()) {
                return;
            }
            TransactionPair tx = (TransactionPair)event.getStructuredSelection().getFirstElement();
            if (tx.getTransaction().getSecurity() != null) {
                this.selectionService.setSelection(new SecuritySelection(owner.getClient(), tx.getTransaction().getSecurity()));
            }
        });
        this.hookContextMenu(parent);
        this.hookKeyListener();
    }

    public void setFullContextMenu(boolean fullContextMenu) {
        this.fullContextMenu = fullContextMenu;
    }

    public Control getControl() {
        return this.tableViewer.getControl().getParent();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void markTransactions(List<TransactionPair<?>> transactions) {
        this.marked.addAll(transactions);
    }

    public void addFilter(ViewerFilter filter) {
        this.tableViewer.addFilter(filter);
    }

    public void setInput(List<TransactionPair<?>> transactions) {
        ISelection selection = this.tableViewer.getSelection();
        this.tableViewer.setInput(transactions);
        this.tableViewer.setSelection(selection);
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void refresh(boolean updateLabels) {
        try {
            this.tableViewer.getControl().setRedraw(false);
            this.tableViewer.refresh(updateLabels);
            this.tableViewer.setSelection(this.tableViewer.getSelection());
        }
        finally {
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        TransactionPair t = (TransactionPair)element;
        if (t.getTransaction().getCrossEntry() != null) {
            t.getTransaction().getCrossEntry().updateFrom(t.getTransaction());
        }
        this.owner.markDirty();
    }

    private void addColumns() {
        Column column = new Column("0", Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> Values.DateTime.format((Object)t.getDateTime())));
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getDateTime()).attachTo(column, 128);
        new DateTimeEditingSupport(Transaction.class, "dateTime").addListener(this).attachTo(column);
        this.support.addColumn(column);
        column = new Column("1", Messages.ColumnTransactionType, 0, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> {
            if (t instanceof PortfolioTransaction) {
                return ((PortfolioTransaction)t).getType().toString();
            }
            if (t instanceof AccountTransaction) {
                return ((AccountTransaction)t).getType().toString();
            }
            return null;
        }));
        ColumnViewerSorter.create(e -> {
            Transaction t = ((TransactionPair)e).getTransaction();
            if (t instanceof PortfolioTransaction) {
                return ((PortfolioTransaction)t).getType().toString();
            }
            if (t instanceof AccountTransaction) {
                return ((AccountTransaction)t).getType().toString();
            }
            return null;
        }).attachTo(column);
        new TransactionTypeEditingSupport(this.owner.getClient()).addListener(this).attachTo(column);
        this.support.addColumn(column);
        column = new Column("2", Messages.ColumnSecurity, 0, 250);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> t.getSecurity() != null ? t.getSecurity().getName() : null, t -> t.getTransaction().getSecurity()));
        ColumnViewerSorter.create(e -> {
            Security s = ((TransactionPair)e).getTransaction().getSecurity();
            return s != null ? s.getName() : null;
        }).attachTo(column);
        this.support.addColumn(column);
        column = new IsinColumn();
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider((ColumnLabelProvider)column.getLabelProvider()));
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new SymbolColumn();
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider((ColumnLabelProvider)column.getLabelProvider()));
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new WknColumn();
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider((ColumnLabelProvider)column.getLabelProvider()));
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new Column("3", Messages.ColumnShares, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){
            private TransactionLabelProvider colors;
            {
                this.colors = new TransactionLabelProvider(t -> null);
            }

            @Override
            public Long getValue(Object element) {
                long shares = ((TransactionPair)element).getTransaction().getShares();
                return shares != 0L ? Long.valueOf(shares) : null;
            }

            @Override
            public Color getForeground(Object element) {
                return this.colors.getForeground(element);
            }

            @Override
            public Color getBackground(Object element) {
                return this.colors.getBackground(element);
            }
        });
        ColumnViewerSorter.create(e -> Long.valueOf(((TransactionPair)e).getTransaction().getShares())).attachTo(column);
        new ValueEditingSupport(Transaction.class, "shares", (Values<? extends Number>)Values.Share).setCanEditCheck(e -> ((TransactionPair)e).getTransaction() instanceof PortfolioTransaction || ((TransactionPair)e).getTransaction() instanceof AccountTransaction && ((AccountTransaction)((TransactionPair)e).getTransaction()).getType() == AccountTransaction.Type.DIVIDENDS).addListener(this).attachTo(column);
        this.support.addColumn(column);
        column = new Column("4", Messages.ColumnQuote, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> {
            if (t instanceof PortfolioTransaction) {
                return t.getShares() != 0L ? Values.CalculatedQuote.format(((PortfolioTransaction)t).getGrossPricePerShare(), this.owner.getClient().getBaseCurrency()) : null;
            }
            return null;
        }));
        ColumnViewerSorter.create(e -> {
            Transaction tx = ((TransactionPair)e).getTransaction();
            return tx instanceof PortfolioTransaction ? ((PortfolioTransaction)tx).getGrossPricePerShare() : null;
        }).attachTo(column);
        this.support.addColumn(column);
        column = new Column("5", Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> {
            Money m = t instanceof PortfolioTransaction ? ((PortfolioTransaction)t).getGrossValue() : ((AccountTransaction)t).getGrossValue();
            return Values.Money.format(m, this.owner.getClient().getBaseCurrency());
        }));
        ColumnViewerSorter.create(e -> {
            Transaction tx = ((TransactionPair)e).getTransaction();
            return tx instanceof PortfolioTransaction ? ((PortfolioTransaction)tx).getGrossValue() : null;
        }).attachTo(column);
        this.support.addColumn(column);
        column = new Column("6", Messages.ColumnFees, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> Values.Money.formatNonZero(t.getUnitSum(Transaction.Unit.Type.FEE), this.owner.getClient().getBaseCurrency())));
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getUnitSum(Transaction.Unit.Type.FEE)).attachTo(column);
        this.support.addColumn(column);
        column = new Column("7", Messages.ColumnTaxes, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> Values.Money.formatNonZero(t.getUnitSum(Transaction.Unit.Type.TAX), this.owner.getClient().getBaseCurrency())));
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getUnitSum(Transaction.Unit.Type.TAX)).attachTo(column);
        this.support.addColumn(column);
        column = new Column("8", Messages.ColumnNetValue, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> Values.Money.format(t.getMonetaryAmount(), this.owner.getClient().getBaseCurrency())));
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getMonetaryAmount()).attachTo(column);
        this.support.addColumn(column);
        column = new Column("account", Messages.ColumnAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(this, t -> null, t -> t.getOwner()){

            @Override
            public String getText(Object element) {
                return ((TransactionPair)element).getOwner().toString();
            }
        });
        new TransactionOwnerListEditingSupport(this.owner.getClient(), TransactionOwnerListEditingSupport.EditMode.OWNER).addListener(this).attachTo(column);
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getOwner().toString()).attachTo(column);
        this.support.addColumn(column);
        column = new Column("9", Messages.ColumnOffsetAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(t -> t.getCrossEntry() != null ? t.getCrossEntry().getCrossOwner(t).toString() : null, t -> t.getTransaction().getCrossEntry() != null ? t.getTransaction().getCrossEntry().getCrossOwner(t.getTransaction()) : null));
        new TransactionOwnerListEditingSupport(this.owner.getClient(), TransactionOwnerListEditingSupport.EditMode.CROSSOWNER).addListener(this).attachTo(column);
        ColumnViewerSorter.create(e -> {
            Transaction t = ((TransactionPair)e).getTransaction();
            return t.getCrossEntry() != null ? t.getCrossEntry().getCrossOwner(t).toString() : null;
        }).attachTo(column);
        this.support.addColumn(column);
        column = new Column("10", Messages.ColumnNote, 0, 200);
        column.setLabelProvider((CellLabelProvider)new TransactionLabelProvider(this, Transaction::getNote){

            @Override
            public Image getImage(Object e) {
                String note = this.getText(e);
                return note != null && !note.isEmpty() ? Images.NOTE.image() : null;
            }

            public String getToolTipText(Object e) {
                String note = this.getText(e);
                return note == null || note.isEmpty() ? null : TextUtil.wordwrap((String)this.getText(e));
            }
        });
        ColumnViewerSorter.create(e -> ((TransactionPair)e).getTransaction().getNote()).attachTo(column);
        new StringEditingSupport(Transaction.class, "note").addListener(this).attachTo(column);
        this.support.addColumn(column);
    }

    public ShowHideColumnHelper getColumnSupport() {
        return this.support;
    }

    private void hookContextMenu(Composite parent) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillTransactionsContextMenu);
        this.contextMenu = menuMgr.createContextMenu((Control)parent.getShell());
        this.tableViewer.getTable().setMenu(this.contextMenu);
        this.tableViewer.getTable().addDisposeListener(e -> this.widgetDisposed());
    }

    private void hookKeyListener() {
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                new TransactionContextMenu(TransactionsViewer.this.owner).handleEditKey(e, TransactionsViewer.this.tableViewer.getStructuredSelection());
            }
        });
    }

    private void widgetDisposed() {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
    }

    private void fillTransactionsContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.tableViewer.getStructuredSelection();
        new TransactionContextMenu(this.owner).menuAboutToShow(manager, this.fullContextMenu, selection);
    }

    private class TransactionLabelProvider
    extends ColumnLabelProvider {
        private Function<Transaction, String> label;
        private Function<TransactionPair<?>, Object> img;

        public TransactionLabelProvider(Function<Transaction, String> label) {
            this(label, null);
        }

        public TransactionLabelProvider(Function<Transaction, String> label, Function<TransactionPair<?>, Object> img) {
            this.label = Objects.requireNonNull(label);
            this.img = img;
        }

        public TransactionLabelProvider(ColumnLabelProvider labelProvider) {
            this.label = arg_0 -> ((ColumnLabelProvider)labelProvider).getText(arg_0);
        }

        public String getText(Object element) {
            return this.label.apply(((TransactionPair)element).getTransaction());
        }

        public Color getForeground(Object element) {
            if (TransactionsViewer.this.marked.contains(element)) {
                return Colors.BLACK;
            }
            Transaction tx = ((TransactionPair)element).getTransaction();
            if (tx instanceof PortfolioTransaction) {
                PortfolioTransaction t = (PortfolioTransaction)tx;
                return t.getType().isLiquidation() ? Colors.theme().redForeground() : Colors.theme().greenForeground();
            }
            if (tx instanceof AccountTransaction) {
                AccountTransaction t = (AccountTransaction)tx;
                return t.getType().isDebit() ? Colors.theme().redForeground() : Colors.theme().greenForeground();
            }
            throw new IllegalArgumentException();
        }

        public Image getImage(Object element) {
            if (this.img == null) {
                return null;
            }
            Object subject = this.img.apply((TransactionPair)element);
            return LogoManager.instance().getDefaultColumnImage(subject, TransactionsViewer.this.owner.getClient().getSettings());
        }

        public Color getBackground(Object element) {
            return TransactionsViewer.this.marked.contains(element) ? Colors.theme().warningBackground() : null;
        }
    }
}

